/*
 * Decompiled with CFR 0.152.
 */
package climatecad;

import climatecad.transPos;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

class climcad
extends JFrame {
    transPos transpos = new transPos();
    String appName = "Design With Climate";
    String appVersion = "beta 0.6";
    String appBuild = "2025-08";
    String appAboutHeader;
    String[] appAboutBody = new String[16];
    boolean english = true;
    File fileDirectory = null;
    String ClimateFn;
    String stationName = "-";
    String stationState = "-";
    String stationCountry = "-";
    String stationZone = "0";
    String stationLat = "45";
    String stationLon = "0";
    String stationAlt = "0";
    double stationZoneVal = Double.parseDouble(this.stationZone);
    double stationLatVal = Double.parseDouble(this.stationLat);
    double stationLonVal = Double.parseDouble(this.stationLon);
    double stationAltVal;
    double userAltVal = this.stationAltVal = Double.parseDouble(this.stationAlt);
    double ICUtempOffset = 0.0;
    int GIECdate = 0;
    int GIECssp = 2;
    int displayMode = 0;
    boolean[] selectMonth = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
    int imgX = 920;
    int imgY = 520;
    int inTop = 0;
    int inLeft = 0;
    int x1 = 0;
    int y1 = 0;
    int x2 = 918;
    int y2 = 460;
    int x1S = 269;
    int x2S = 334;
    int y1S = 16;
    int y2S = 201;
    int x1T = this.x1 + 20;
    int y1T = this.y1 + 140;
    int x2T = 520;
    int y2T = 120;
    int x1R = this.x1 + 20;
    int y1R = this.y1 + 115;
    int x2R = 290;
    int y2R = 290;
    Color applicationBackgroundColor = new Color(24, 24, 24);
    Color applicationPrintableBackgound = Color.white;
    Font tableFont = new Font("lucida console", 0, 11);
    Color tableColor = Color.white;
    Color graphGridColor = Color.gray;
    Color graphBackgroundColor = Color.black;
    Color graphLegendColor = Color.black;
    Color graphBorderColor = Color.gray;
    int zoomMode = 2;
    double[] ex0 = new double[]{-40.0, 0.0, -15.0, -25.0, -40.0};
    double[] ex1 = new double[]{55.0, 55.0, 40.0, 30.0, 15.0};
    double[] exi = new double[]{10.0, 5.0, 5.0, 5.0, 5.0};
    double[] ey0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    double[] ey1 = new double[]{0.08, 0.08, 0.04, 0.025, 0.015};
    int palette = 0;
    int colorSetSize = 10;
    Color[][] colorSet = new Color[][]{{Color.white, Color.white, Color.gray, new Color(0, 0, 150), Color.blue, Color.green, Color.green, Color.orange, Color.red, new Color(160, 0, 0), Color.magenta}, {new Color(100, 0, 100), new Color(100, 0, 100), new Color(0, 0, 100), new Color(0, 0, 255), new Color(255, 255, 0), new Color(255, 255, 0), new Color(255, 128, 0), new Color(255, 0, 0), new Color(160, 0, 0)}, {new Color(255, 0, 255), new Color(255, 0, 255), new Color(0, 0, 255), new Color(0, 255, 255), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 0, 0), new Color(255, 0, 0)}, {Color.black, Color.black, new Color(80, 0, 120), new Color(0, 0, 200), new Color(0, 160, 255), new Color(128, 255, 255), Color.orange, Color.yellow, Color.white, Color.white}, {Color.black, Color.black, Color.gray, Color.orange, Color.yellow, Color.white}, {Color.black, Color.black, new Color(0, 0, 128), Color.blue, Color.green, Color.yellow, Color.orange, Color.red, Color.black}, {Color.blue, Color.green, Color.red, Color.yellow, Color.blue}, {this.applicationBackgroundColor, Color.green, Color.yellow, Color.red, Color.black}, {Color.blue, new Color(128, 255, 255), Color.darkGray}};
    double[][] tempSet = new double[][]{{-50.0, -5.0, 0.0, 5.0, 14.0, 22.0, 24.0, 27.0, 32.0, 36.0, 60.0}, {-50.0, 0.0, 8.0, 16.0, 20.0, 24.0, 30.0, 35.0, 60.0}, {-50.0, 0.0, 8.0, 16.0, 24.0, 30.0, 35.0, 60.0}, {-90.0, -20.0, -14.0, -8.0, -4.0, -0.2, 0.0, 12.0, 55.0, 90.0}, {-100.0, 0.0, 150.0, 450.0, 800.0, 1500.0}, {-100.0, 0.0, 1.0, 2.0, 4.0, 6.0, 12.0, 25.0, 100.0}, {-1.0, 90.0, 180.0, 270.0, 361.0}, {0.0, 144.0, 310.0, 600.0, 9000.0}, {0.0, 5.0, 11.0}};
    double[][] stratProperties = new double[][]{{3.0, 23.0, 50.0, 250.0, 75.0, 10.0, 100.0}, {2.0, -5.0, 140.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 10.0, 15.0, 10.0, 170.0, 250.0, 50.0}, {2.0, 5.0, 125.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 0.0, 50.0, 250.0, 15.0, 15.0, 75.0}, {3.0, 6.0, 125.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 8.0, 50.0, 240.0, 5.0, 5.0, 30.0}, {3.0, 8.0, 125.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 12.0, 120.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 18.0, 120.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 18.0, 130.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 20.0, 120.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 17.0, 50.0, 180.0, 180.0, 180.0, 30.0}, {3.0, 22.0, 115.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 28.0, 115.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 28.0, 30.0, 245.0, 250.0, 10.0, 75.0}, {3.0, 33.0, 34.0, 245.0, 250.0, 10.0, 50.0}, {3.0, 26.0, 83.0, 60.0, 210.0, 60.0, 50.0}, {3.0, 35.0, 7.0, 20.0, 10.0, 250.0, 45.0}, {3.0, 45.0, 50.0, 15.0, 60.0, 250.0, 30.0}};
    int[][] labelColor = new int[this.stratProperties.length][4];
    int stratMode = 0;
    double[][] droites = new double[][]{{1.0, 1.0, -5.0, 0.0, -5.0, 100.0, 0.0, 0.0}, {2.0, 4.0, 2.0, 0.0, 2.0, 100.0, 0.0, 0.0}, {22.0, 5.0, 6.0, 0.0, 6.0, 100.0, 0.0, 0.0}, {3.0, 7.0, 8.0, 0.0, 8.0, 100.0, 0.0, 0.0}, {3.0, 7.0, -5.0, 0.0, -5.0, 100.0, 1.0, 0.0}, {4.0, 8.0, 12.0, 0.0, 12.0, 100.0, 0.0, 0.0}, {5.0, 6.0, 10.0, 0.0, 10.0, 100.0, 0.0, 0.0}, {6.0, 9.0, 18.0, 0.0, 18.0, 100.0, 0.0, 0.0}, {23.0, 10.0, 18.0, 0.0, 18.0, 100.0, 0.0, 0.0}, {7.0, 11.0, 16.0, 0.0, 16.0, 100.0, 0.0, 0.0}, {8.0, 13.0, 19.0, 0.0, 19.0, 100.0, 1.0, 0.0}, {9.0, 14.0, 28.0, 0.0, 28.0, 100.0, 1.0, 0.0}, {16.0, 3.0, 5.0, 0.0, 5.0, 100.0, 0.0, 0.0}, {0.0, 0.0, 20.0, 20.0, 20.0, 80.0, 1.0, 0.0}, {0.0, 0.0, 20.0, 80.0, 22.0, 80.0, 3.0, 0.0}, {0.0, 0.0, 22.0, 80.0, 26.5, 50.0, 0.0, 0.0}, {0.0, 0.0, 26.5, 50.0, 26.5, 18.0, 0.0, 0.0}, {0.0, 0.0, 20.0, 20.0, 26.5, 18.0, 2.0, 0.0}, {18.0, 12.0, 8.0, 0.0, 8.0, 100.0, 1.0, 0.0}, {18.0, 12.0, 20.0, 100.0, 29.0, 60.0, 3.0, 0.0}, {18.0, 12.0, 29.0, 60.0, 38.0, 28.0, 3.0, 0.0}, {18.0, 12.0, 38.0, 0.0, 38.0, 28.0, 0.0, 0.0}, {10.0, 15.0, 23.4, 70.0, 26.5, 50.0, 2.0, 0.0}, {10.0, 15.0, 23.4, 70.0, 25.0, 70.0, 3.0, 0.0}, {10.0, 15.0, 25.0, 70.0, 32.0, 37.0, 3.0, 0.0}, {10.0, 15.0, 26.5, 50.0, 32.0, 37.0, 2.0, 0.0}, {19.0, 15.0, 26.5, 18.0, 26.5, 50.0, 1.0, 0.0}, {19.0, 15.0, 26.5, 50.0, 32.0, 37.0, 3.0, 0.0}, {19.0, 15.0, 32.0, 16.0, 32.0, 37.0, 0.0, 0.0}, {19.0, 15.0, 26.5, 18.0, 32.0, 16.0, 2.0, 0.0}, {11.0, 16.0, 32.0, 16.0, 32.0, 37.0, 1.0, 0.0}, {11.0, 16.0, 32.0, 37.0, 38.0, 28.0, 3.0, 0.0}, {11.0, 16.0, 38.0, 14.0, 38.0, 28.0, 2.0, 0.0}, {11.0, 16.0, 32.0, 16.0, 38.0, 14.0, 2.0, 0.0}, {20.0, 16.0, 26.8, 60.0, 29.0, 60.0, 3.0, 0.0}, {20.0, 16.0, 26.8, 60.0, 32.0, 37.0, 2.0, 0.0}, {20.0, 16.0, 29.0, 60.0, 38.0, 28.0, 3.0, 0.0}, {20.0, 16.0, 32.0, 37.0, 38.0, 28.0, 2.0, 0.0}, {12.0, 17.0, 20.0, 100.0, 22.0, 80.0, 1.0, 0.0}, {12.0, 17.0, 20.0, 100.0, 27.5, 100.0, 3.0, 0.0}, {12.0, 17.0, 27.5, 100.0, 30.0, 80.0, 3.0, 0.0}, {12.0, 17.0, 30.0, 40.0, 30.0, 80.0, 0.0, 0.0}, {12.0, 17.0, 26.5, 50.0, 30.0, 40.0, 2.0, 0.0}, {12.0, 17.0, 22.0, 80.0, 26.5, 50.0, 2.0, 0.0}, {21.0, 17.0, 26.5, 20.0, 26.5, 50.0, 1.0, 0.0}, {21.0, 17.0, 26.5, 50.0, 30.0, 40.0, 3.0, 0.0}, {21.0, 17.0, 30.0, 20.0, 30.0, 40.0, 0.0, 0.0}, {21.0, 17.0, 26.5, 20.0, 30.0, 20.0, 2.0, 0.0}, {13.0, 19.0, 27.5, 100.0, 30.0, 80.0, 2.0, 0.0}, {13.0, 19.0, 30.0, 80.0, 55.0, 22.0, 2.0, 0.0}, {26.0, 19.0, 30.0, 55.0, 30.0, 80.0, 1.0, 0.0}, {26.0, 19.0, 30.0, 80.0, 55.0, 22.0, 3.0, 0.0}, {26.0, 19.0, 55.0, 12.0, 55.0, 22.0, 0.0, 0.0}, {26.0, 19.0, 38.0, 28.0, 55.0, 12.0, 2.0, 0.0}, {26.0, 19.0, 30.0, 55.0, 38.0, 28.0, 2.0, 0.0}, {24.0, 19.0, 38.0, 20.0, 38.0, 28.0, 1.0, 0.0}, {24.0, 19.0, 38.0, 28.0, 55.0, 12.0, 3.0, 0.0}, {24.0, 19.0, 55.0, 6.0, 55.0, 12.0, 0.0, 0.0}, {24.0, 19.0, 45.0, 9.0, 55.0, 6.0, 2.0, 0.0}, {24.0, 19.0, 38.0, 20.0, 45.0, 9.0, 2.0, 0.0}, {25.0, 19.0, 45.0, 0.0, 45.0, 9.0, 1.0, 0.0}, {25.0, 19.0, 45.0, 9.0, 55.0, 6.0, 3.0, 1.0}, {25.0, 19.0, 55.0, 0.0, 55.0, 6.0, 0.0, 0.0}, {25.0, 19.0, 45.0, 0.0, 55.0, 0.0, 2.0, 0.0}, {27.0, 18.0, 26.5, 18.0, 26.5, 30.0, 1.0, 0.0}, {27.0, 18.0, 26.5, 30.0, 34.0, 30.0, 3.0, 0.0}, {27.0, 18.0, 34.0, 30.0, 45.0, 9.0, 3.0, 0.0}, {27.0, 18.0, 26.5, 18.0, 45.0, 9.0, 2.0, 0.0}, {14.0, 18.0, 22.0, 20.0, 26.5, 18.0, 3.0, 0.0}, {14.0, 18.0, 26.5, 18.0, 45.0, 9.0, 3.0, 0.0}, {14.0, 18.0, 45.0, 9.0, 45.0, 0.0, 0.0, 0.0}, {14.0, 18.0, 22.0, 0.0, 22.0, 20.0, 1.0, 0.0}, {28.0, 2.0, -40.0, 80.0, 0.0, 35.0, 3.0, 0.0}, {28.0, 2.0, 0.0, 0.0, 0.0, 35.0, 0.0, 0.0}, {15.0, 2.0, 0.0, 0.0, 0.0, 35.0, 1.0, 0.0}, {15.0, 2.0, 0.0, 35.0, 22.0, 20.0, 3.0, 0.0}, {15.0, 2.0, 22.0, 20.0, 28.5, 0.0, 3.0, 0.0}};
    int[] JM;
    int[] joursMois;
    String[] nomMois;
    String header;
    String title;
    String titleHours;
    String titlePercent;
    String titleAnalysis;
    String legend0;
    String legend1;
    String legend2;
    String footer;
    String[] stratLabel;
    double[] c0;
    double[] c1;
    int[] comptesGrp;
    int[][] tableau;
    double[] T;
    double[] H;
    double[] M;
    double[] G;
    double[] D;
    double[] Wd;
    double[] Wv;
    double[] Cc;
    double[] Pr;
    boolean[] draw;
    String outAnalysis;
    String[] txtAnalysis;
    String[][] valAnalysis;
    String[] txtPercent;
    String[][] valPercent;
    String[] txtHours;
    String[][] valHours;
    String[] txtClimate;
    String[] txtDaynight;
    String[] txtSun;
    String[] txtWind;
    Container container;
    private JPanel jPa_0;
    private JLabel jLa_T;
    private JLabel jLa_H;
    private JLabel jLa_S;
    graphDisplay gDisplay;

    public climcad(String ClimFn) {
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        nArray[12] = 365;
        this.JM = nArray;
        this.joursMois = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        this.nomMois = new String[12];
        this.stratLabel = new String[this.stratProperties.length];
        this.c0 = new double[2];
        this.c1 = new double[2];
        this.comptesGrp = new int[this.stratProperties.length];
        this.tableau = new int[13][this.droites.length];
        this.T = new double[8761];
        this.H = new double[8761];
        this.M = new double[8761];
        this.G = new double[8761];
        this.D = new double[8761];
        this.Wd = new double[8761];
        this.Wv = new double[8761];
        this.Cc = new double[8761];
        this.Pr = new double[8761];
        this.draw = new boolean[8761];
        this.outAnalysis = "";
        this.txtAnalysis = new String[this.stratProperties.length + 1];
        this.valAnalysis = new String[13][this.stratProperties.length + 1];
        this.txtPercent = new String[this.stratProperties.length + 1];
        this.valPercent = new String[13][this.stratProperties.length + 1];
        this.txtHours = new String[this.stratProperties.length + 1];
        this.valHours = new String[13][this.stratProperties.length + 1];
        this.txtClimate = new String[13];
        this.txtDaynight = new String[10];
        this.txtSun = new String[7];
        this.txtWind = new String[10];
        this.container = this.getContentPane();
        this.jPa_0 = new JPanel();
        this.jLa_T = new JLabel();
        this.jLa_H = new JLabel();
        this.jLa_S = new JLabel();
        this.gDisplay = new graphDisplay();
        this.ClimateFn = ClimFn;
        this.jPa_0.setLayout(null);
        this.jPa_0.setBounds(this.imgX - 200, this.inTop + 12, 160, 35);
        this.jPa_0.setBackground(Color.black);
        this.jPa_0.setBorder(BorderFactory.createLineBorder(Color.gray));
        Font statusFont = new Font("dialog", 1, 10);
        this.jLa_T.setBounds(new Rectangle(5, 2, 150, 10));
        this.jLa_T.setFont(statusFont);
        this.jLa_T.setForeground(Color.white);
        this.jLa_T.setText("'move' on graph");
        this.jLa_H.setBounds(new Rectangle(5, 12, 150, 10));
        this.jLa_H.setFont(statusFont);
        this.jLa_H.setForeground(Color.white);
        this.jLa_H.setText("> ready");
        this.jLa_S.setBounds(new Rectangle(5, 22, 150, 10));
        this.jLa_S.setFont(statusFont);
        this.jLa_S.setForeground(Color.white);
        this.jPa_0.add((Component)this.jLa_T, null);
        this.jPa_0.add((Component)this.jLa_H, null);
        this.jPa_0.add((Component)this.jLa_S, null);
        this.container.add((Component)this.jPa_0, null);
        new transPos();
        this.langSet();
        int i = 0;
        while (i < this.stratProperties.length) {
            this.labelColor[i][0] = (int)this.stratProperties[i][3];
            this.labelColor[i][1] = (int)this.stratProperties[i][4];
            this.labelColor[i][2] = (int)this.stratProperties[i][5];
            this.labelColor[i][3] = (int)this.stratProperties[i][6];
            ++i;
        }
        String fExt = this.ClimateFn == null || this.ClimateFn.length() < 3 ? this.ClimateFn : this.ClimateFn.substring(this.ClimateFn.length() - 3);
        this.readFile(this.ClimateFn, fExt);
        this.analyseData();
        this.setSize(2 * this.inLeft + this.imgX + 20, this.inTop + this.imgY + 40);
        this.setTitle(this.appName);
        this.setIconImage(new ImageIcon(this.getClass().getResource("icon.png")).getImage());
        this.setResizable(false);
        this.gDisplay.setVisible(false);
        this.gDisplay.setBackground(this.applicationBackgroundColor);
        this.add(this.gDisplay);
        this.gDisplay.setVisible(true);
        this.setJMenuBar(new myMenu());
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.gDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
            }
        });
        this.gDisplay.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                int xPos = evt.getX();
                int yPos = evt.getY();
                if (climcad.this.displayMode < 20) {
                    if (xPos > climcad.this.x1T && xPos < climcad.this.x1T + climcad.this.x2T && yPos > climcad.this.y1T && yPos < climcad.this.y1T + climcad.this.y2T && climcad.this.displayMode > 3 && climcad.this.displayMode != 9) {
                        climcad.this.setCursor(new Cursor(1));
                        double[] result = climcad.this.transformReverseT(xPos, yPos);
                        if (climcad.this.displayMode == 4) {
                            climcad.this.jLa_T.setText("T : " + String.format("%.1f", result[0]) + "\u00baC" + "   Td : " + String.format("%.1f", result[2]) + "\u00baC");
                            climcad.this.jLa_H.setText("HR : " + String.format("%.0f", result[1]) + "%");
                        } else if (climcad.this.displayMode == 5) {
                            climcad.this.jLa_T.setText("hc : " + String.format("%.0f", result[0]) + "\u00ba");
                            climcad.this.jLa_H.setText("az : " + String.format("%.0f", result[1]) + "\u00ba");
                        } else if (climcad.this.displayMode == 6) {
                            climcad.this.jLa_T.setText("Gh : " + String.format("%.0f", result[0]) + " W/m2");
                            climcad.this.jLa_H.setText("Dh : " + String.format("%.0f", result[1]) + " W/m2");
                        } else if (climcad.this.displayMode == 7 || climcad.this.displayMode == 8) {
                            climcad.this.jLa_T.setText("Wv : " + String.format("%.1f", result[0]) + " m/s (" + String.format("%.1f", result[0] * 3.6) + " km/h)");
                            if (result[1] > 0.0) {
                                climcad.this.jLa_H.setText("Wd : " + String.format("%.0f", result[1]) + "\u00ba");
                            } else {
                                climcad.this.jLa_H.setText("Wd : -");
                            }
                        }
                        climcad.this.jLa_S.setText(climcad.this.dateReverse(xPos, yPos));
                    } else if (yPos < climcad.this.y1 + climcad.this.y2 && yPos > climcad.this.y1 + 3) {
                        double[] result = climcad.this.transformReverse(xPos, yPos);
                        if (result[1] <= 100.0) {
                            String timeStamp = climcad.this.dataReverse(result[0], result[1]);
                            String sT = String.format("%.1f", result[0]);
                            String sH = String.format("%.0f", result[1]);
                            String sTd = String.format("%.1f", result[2]);
                            climcad.this.jLa_T.setText("T : " + sT + "\u00baC" + "   Td : " + sTd + "\u00baC");
                            climcad.this.jLa_H.setText("RH : " + sH + "%");
                            String stratList = "Strat : ";
                            if (timeStamp == null && climcad.this.displayMode > 0 && climcad.this.displayMode < 4) {
                                int[] strat = climcad.this.testStrategy(result[0], result[1]);
                                int i = 0;
                                while (i < strat.length) {
                                    if (strat[i] == 1) {
                                        stratList = String.valueOf(stratList) + i + ".";
                                    }
                                    ++i;
                                }
                                climcad.this.jLa_S.setText(stratList);
                            } else {
                                climcad.this.jLa_S.setText(timeStamp);
                            }
                            climcad.this.setCursor(new Cursor(1));
                        } else {
                            climcad.this.setCursor(new Cursor(0));
                            climcad.this.jLa_T.setText(climcad.this.english ? "Move over graph" : "Survolez le graphique");
                            climcad.this.jLa_H.setText(climcad.this.english ? "> ready" : "> en attente");
                            climcad.this.jLa_S.setText(String.valueOf(String.format("%.0f", xPos)) + " / " + String.format("%.0f", yPos));
                        }
                    } else {
                        climcad.this.setCursor(new Cursor(0));
                    }
                }
            }
        });
    }

    private void langSet() {
        this.appAboutHeader = this.english ? "Design With Climate" : "Design With Climate";
        this.appAboutBody[0] = " ";
        this.appAboutBody[1] = this.english ? "Climatic design accounts for efficient building design, can greatly" : "La prise en compte du climat dans la conception des b\u00c3\u00a2timents les rend plus";
        this.appAboutBody[2] = this.english ? "improve user experience and sustainability and offers a huge" : "agr\u00e9ables \u00e5 vivre, plus rationnels, plus durables et offre un \u00e9norme";
        this.appAboutBody[3] = this.english ? "potential for energy savings." : "potentiel d'\u00e9conomies d'\u00e9nergie.";
        this.appAboutBody[4] = " ";
        this.appAboutBody[5] = this.english ? String.valueOf(this.appName) + " illustrates climate patterns and evaluates the most" : String.valueOf(this.appName) + " visualise des donn\u00e9es climatiques et \u00e9value les strat\u00e9gies";
        this.appAboutBody[6] = this.english ? "relevant climatic design strategies using the psychrometric" : "climatiques les plus pertinentes selon la methode du diagramme d'air humide";
        this.appAboutBody[7] = this.english ? "chart method and data from EPW format climate files." : "et d'un fichier m\u00e9t\u00e9o horaire au format EPW.";
        this.appAboutBody[8] = " ";
        this.appAboutBody[9] = this.english ? "The program evaluates 12 winter and 7 summer strategies." : "Le programme \u00e9value 12 strat\u00e9gies d'hiver et 7 strat\u00e9gies d'\u00e9t\u00e9";
        this.appAboutBody[10] = this.english ? "Results must be adapted to take into account" : "en fonction des conditions climatiques de la station. Cette analyse";
        this.appAboutBody[11] = this.english ? "microclimate patterns." : "doit \u00c3\u00aatre pond\u00e9r\u00e9e en tenant compte du microclimat local.";
        this.appAboutBody[12] = " ";
        this.appAboutBody[13] = this.english ? "Brought to you by 'The Passive Igloo Project'" : "Propos\u00e9 par 'The Passive Igloo Project'";
        this.appAboutBody[14] = " ";
        this.appAboutBody[15] = this.english ? "Open a file and explore ..." : "Ouvrez un fichier et explorez ...";
        this.header = this.english ? "DWC : Design With Climate\n\nPsychrometric chart method based on theoretical work by B.Givoni and M.Milne.\nCold climates, adaptation and development by P.Gallinelli - 2016 - the passive igloo project" : "Desing With Climate\n\nAnalyse climatique selon la m\u00e9thode du diagramme d'air humide propos\u00e9e par B.Givoni et M.Milne.\nAdaptation strat\u00e9gies climats froids P.Gallinelli - 2016 - the passive igloo project";
        this.title = this.english ? "Strategies" : "Strat\u00e9gies";
        this.titleHours = this.english ? "Strategies net hours" : "Heures Strat\u00e9gies ";
        this.titlePercent = this.english ? "Strategies percentages" : "Pourcent Strat\u00e9gies";
        this.titleAnalysis = this.english ? "Weighted strategies analysis" : "Analyse Strat\u00e9gies pond\u00e9r\u00e9es";
        this.legend0 = this.english ? "One year = 8760 hours" : "Une ann\u00e9e = 8760 heures";
        this.legend1 = this.english ? "Legend  : +++ = mandatory; ++ = recommended; + = to consider ; - = non applicable" : "L\u00e9gende : +++ = incontournable; ++ = recommand\u00e9; + = \u00e5 consid\u00e9rer; - = non pertinent";
        this.legend2 = this.english ? "     () : contained in comfort zone" : "     () : compris dans zone de confort";
        this.footer = this.english ? "Winter strategies 1..12 : collect, stock, conserve, distribute\nSummer strategies 13..19 : protect, avoid, minimise, evacuate, delay, cool" : "Strat\u00e9gies hiver 1..12 : capter, stocker, conserver, distribuer\nStrat\u00e9gies \u00e9t\u00e9 13..19 : prot\u00e9ger, \u00e9viter, minimiser, dissiper, d\u00e9phaser, rafra\u00c3\u00aechir";
        this.stratLabel[0] = this.english ? " 0. comfort zone (no action needed) " : " 0. zone de confort (pas d'action)  ";
        this.stratLabel[1] = this.english ? " 1. ventilation heat recovery + BP  " : " 1. DF avec puits canadien          ";
        this.stratLabel[2] = this.english ? " 2. humidification                  " : " 2. humidification                  ";
        this.stratLabel[3] = this.english ? " 3. compact geometry                " : " 3. forme compacte                  ";
        this.stratLabel[4] = this.english ? " 4. active heating                  " : " 4. chauffage actif                 ";
        this.stratLabel[5] = this.english ? " 5. high thermal insulation         " : " 5. isolation thermique renforc\u00e9e   ";
        this.stratLabel[6] = this.english ? " 6. auxiliary heating               " : " 6. chauffage d'appoint             ";
        this.stratLabel[7] = this.english ? " 7. ventilation heat recovery       " : " 7. ventilation contr\u00f4l\u00e9e ou DF     ";
        this.stratLabel[8] = this.english ? " 8. wind protection + airtightness  " : " 8. protection du vent + \u00e9tanch\u00e9it\u00e9 ";
        this.stratLabel[9] = this.english ? " 9. solar heat gains                " : " 9. apports solaires                ";
        this.stratLabel[10] = this.english ? "10. thermal insulation             " : "10. isolation thermique             ";
        this.stratLabel[11] = this.english ? "11. buffer spaces               () " : "11. espaces tampons              () ";
        this.stratLabel[12] = this.english ? "12. thermal mass                () " : "12. masse thermique              () ";
        this.stratLabel[13] = this.english ? "13. window protection           () " : "13. protection des ouvertures    () ";
        this.stratLabel[14] = this.english ? "14. envelope protection            " : "14. protection des facades          ";
        this.stratLabel[15] = this.english ? "15. massive construction or BP     " : "15. construction lourde ou PC       ";
        this.stratLabel[16] = this.english ? "16. massive + night ventilation    " : "16. lourd + ventilation nocturne    ";
        this.stratLabel[17] = this.english ? "17. natural ventilation            " : "17. ventilation naturelle           ";
        this.stratLabel[18] = this.english ? "18. evaporative cooling            " : "18. refroidissement \u00e9vaporatif      ";
        this.stratLabel[19] = this.english ? "19. active cooling                 " : "19. refroidissement actif           ";
        this.nomMois[0] = this.english ? "January" : "janvier";
        this.nomMois[1] = this.english ? "February" : "f\u00e9vrier";
        this.nomMois[2] = this.english ? "March" : "mars";
        this.nomMois[3] = this.english ? "April" : "avril";
        this.nomMois[4] = this.english ? "May" : "mai";
        this.nomMois[5] = this.english ? "June" : "juin";
        this.nomMois[6] = this.english ? "July" : "juillet";
        this.nomMois[7] = this.english ? "August" : "ao\u00fbt";
        this.nomMois[8] = this.english ? "September" : "septembre";
        this.nomMois[9] = this.english ? "October" : "octobre";
        this.nomMois[10] = this.english ? "November" : "novembre";
        this.nomMois[11] = this.english ? "December" : "d\u00e9cembre";
    }

    private void icuDlg() {
        String txt = "<html><body>Temp. offset [\u00baC]</body></html>";
        String str = JOptionPane.showInputDialog(null, txt, String.format("%.0f", this.ICUtempOffset));
        if (str != null) {
            this.ICUtempOffset = Double.parseDouble(str);
        }
    }

    private void altDlg() {
        String txt = "<html><body><br>" + (this.english ? "EPW climate file altitude : " : "Altitude station fichier EPW : ") + this.stationAlt + " [m]<br>" + (this.english ? "New altitude ? [m]" : "Nouvelle altitude ? [m]") + "</body></html>";
        String str = JOptionPane.showInputDialog(null, txt, String.format("%.0f", this.userAltVal));
        if (str != null) {
            this.userAltVal = Double.parseDouble(str);
        }
    }

    private double[] HOYtoDate(double hoy) {
        int doy = (int)Math.floor(hoy / 24.0);
        int hh = (int)hoy - doy * 24;
        int min = (int)((hoy - Math.floor(hoy)) * 60.0);
        int mm = 1;
        while (doy > this.JM[mm]) {
            ++mm;
        }
        int dd = doy - this.JM[mm - 1];
        double[] result = new double[]{mm, dd, hh, min};
        return result;
    }

    private double simTemp(double T) {
        T += this.ICUtempOffset;
        T += (this.stationAltVal - this.userAltVal) / 100.0 * 0.65;
        double[] dT2040 = new double[]{1.5, 1.5, 1.5, 1.6, 1.6};
        double[] dT2060 = new double[]{1.6, 1.7, 2.0, 2.1, 2.4};
        double[] dT2100 = new double[]{1.4, 1.8, 2.7, 3.6, 4.4};
        switch (this.GIECdate) {
            case 1: {
                T = T + dT2040[this.GIECssp] + 1.0;
                break;
            }
            case 2: {
                T = T + dT2060[this.GIECssp] + 1.5;
                break;
            }
            case 3: {
                T = T + dT2100[this.GIECssp] + 2.5;
            }
        }
        return T;
    }

    private Color getColor(double T) {
        Color col = this.getColorPal(this.simTemp(T), this.palette);
        return col;
    }

    private Color getColorPal(double val, int palette) {
        int r0 = 0;
        int g0 = 0;
        int b0 = 0;
        int r1 = 0;
        int g1 = 0;
        int b1 = 0;
        int rx = 0;
        int gx = 0;
        int bx = 0;
        double m = 0.0;
        double b = 0.0;
        int j = 1;
        while (j < this.colorSetSize) {
            if (val < this.tempSet[palette][j]) {
                r0 = this.colorSet[palette][j - 1].getRed();
                g0 = this.colorSet[palette][j - 1].getGreen();
                b0 = this.colorSet[palette][j - 1].getBlue();
                r1 = this.colorSet[palette][j].getRed();
                g1 = this.colorSet[palette][j].getGreen();
                b1 = this.colorSet[palette][j].getBlue();
                m = (double)(r1 - r0) / (this.tempSet[palette][j] - this.tempSet[palette][j - 1]);
                b = (double)r1 - m * this.tempSet[palette][j];
                rx = Math.min(255, Math.max(0, (int)(m * val + b)));
                m = (double)(g1 - g0) / (this.tempSet[palette][j] - this.tempSet[palette][j - 1]);
                b = (double)g1 - m * this.tempSet[palette][j];
                gx = Math.min(255, Math.max(0, (int)(m * val + b)));
                m = (double)(b1 - b0) / (this.tempSet[palette][j] - this.tempSet[palette][j - 1]);
                b = (double)b1 - m * this.tempSet[palette][j];
                bx = Math.min(255, Math.max(0, (int)(m * val + b)));
                break;
            }
            ++j;
        }
        Color col = new Color(rx, gx, bx);
        return col;
    }

    private void analyseData() {
        int month;
        double TAmin = 50.0;
        double TAmax = -50.0;
        double TAsum = 0.0;
        double TAavg = 0.0;
        double DJ1810A = 0.0;
        double DJ2012A = 0.0;
        double DJ2214A = 0.0;
        double DJGA = 0.0;
        double GAsum = 0.0;
        double DAsum = 0.0;
        double WVAmax = 0.0;
        double WVAavg = 0.0;
        double WVAsum = 0.0;
        double WEAsum = 0.0;
        double WHAsum = 0.0;
        double DNDAsum = 0.0;
        double DNCAsum = 0.0;
        double DNNAsum = 0.0;
        double DNAAsum = 0.0;
        double DNXAsum = 0.0;
        double[] TMmin = new double[13];
        double[] TMmax = new double[13];
        double[] TMsum = new double[13];
        double[] TMavg = new double[13];
        double[] DJ1810 = new double[13];
        double[] DJ2012 = new double[13];
        double[] DJ2214 = new double[13];
        double[] DJG = new double[13];
        double[] GMsum = new double[13];
        double[] DMsum = new double[13];
        double[] WVMmax = new double[13];
        double[] WVMavg = new double[13];
        double[] WVMsum = new double[13];
        double[] WEMsum = new double[13];
        double[] WHMsum = new double[13];
        double[] DNDMsum = new double[13];
        double[] DNCMsum = new double[13];
        double[] DNNMsum = new double[13];
        double[] DNAMsum = new double[13];
        double[] DNXMsum = new double[13];
        int m = 0;
        while (m < TMmin.length) {
            TMmin[m] = 50.0;
            TMmax[m] = -50.0;
            TMsum[m] = 0.0;
            TMavg[m] = 0.0;
            GMsum[m] = 0.0;
            WVMsum[m] = 0.0;
            WVMmax[m] = 0.0;
            WVMavg[m] = 0.0;
            WEMsum[m] = 0.0;
            WHMsum[m] = 0.0;
            DNDMsum[m] = 0.0;
            DNNMsum[m] = 0.0;
            DNNMsum[m] = 0.0;
            DNAMsum[m] = 0.0;
            ++m;
        }
        double count = 0.0;
        int m2 = 1;
        while (m2 < 13) {
            int i = 0;
            while (i < this.T.length) {
                if (this.M[i] == (double)m2 && this.selectMonth[m2 - 1]) {
                    int[] cnt = this.testStrategy(this.simTemp(this.T[i]), this.H[i]);
                    int d = 0;
                    while (d < cnt.length) {
                        int n = d;
                        this.comptesGrp[n] = this.comptesGrp[n] + cnt[d];
                        ++d;
                    }
                    this.draw[i] = true;
                    if (this.simTemp(this.T[i]) <= 10.0) {
                        int n = m2;
                        DJ1810[n] = DJ1810[n] + (18.0 - this.simTemp(this.T[i]));
                    }
                    if (this.simTemp(this.T[i]) <= 12.0) {
                        int n = m2;
                        DJ2012[n] = DJ2012[n] + (20.0 - this.simTemp(this.T[i]));
                    }
                    if (this.simTemp(this.T[i]) <= 14.0) {
                        int n = m2;
                        DJ2214[n] = DJ2214[n] + (22.0 - this.simTemp(this.T[i]));
                    }
                    if (this.simTemp(this.T[i]) < 0.0) {
                        int n = m2;
                        DJG[n] = DJG[n] + (0.0 - this.simTemp(this.T[i]));
                    }
                    TMmin[m2] = Math.min(TMmin[m2], this.simTemp(this.T[i]));
                    TMmax[m2] = Math.max(TMmax[m2], this.simTemp(this.T[i]));
                    int n = m2;
                    TMsum[n] = TMsum[n] + this.simTemp(this.T[i]);
                    int n2 = m2;
                    GMsum[n2] = GMsum[n2] + this.G[i];
                    int n3 = m2;
                    DMsum[n3] = DMsum[n3] + this.D[i];
                    WVMmax[m2] = Math.max(WVMmax[m2], this.Wv[i]);
                    int n4 = m2;
                    WVMsum[n4] = WVMsum[n4] + this.Wv[i];
                    int n5 = m2;
                    WEMsum[n5] = WEMsum[n5] + (this.Wv[i] > 4.0 && this.Wv[i] < 25.0 ? 1.29 * Math.pow(this.Wv[i], 3.0) * 0.5 / 2.0 : 0.0);
                    int n6 = m2;
                    WHMsum[n6] = WHMsum[n6] + (double)(this.Wv[i] > 4.0 && this.Wv[i] < 25.0 ? 1 : 0);
                    count += 1.0;
                    double hc = Math.toDegrees(this.transpos.getHC(Math.toRadians(Double.parseDouble(this.stationLat)), i));
                    int n7 = m2;
                    DNDMsum[n7] = DNDMsum[n7] + (double)(hc > 0.0 ? 1 : 0);
                    int n8 = m2;
                    DNCMsum[n8] = DNCMsum[n8] + (double)(hc > -6.0 && hc <= 0.0 ? 1 : 0);
                    int n9 = m2;
                    DNNMsum[n9] = DNNMsum[n9] + (double)(hc > -12.0 && hc <= -6.0 ? 1 : 0);
                    int n10 = m2;
                    DNAMsum[n10] = DNAMsum[n10] + (double)(hc > -18.0 && hc <= -12.0 ? 1 : 0);
                }
                TMavg[m2] = TMsum[m2] / (double)(this.joursMois[m2 - 1] * 24);
                WVMavg[m2] = WVMsum[m2] / (double)(this.joursMois[m2 - 1] * 24);
                ++i;
            }
            DNXMsum[m2] = (double)(this.joursMois[m2 - 1] * 24) - DNDMsum[m2] - DNCMsum[m2] - DNNMsum[m2] - DNAMsum[m2];
            DJ1810[m2] = DJ1810[m2] / 24.0;
            DJ1810A += DJ1810[m2];
            DJ2012[m2] = DJ2012[m2] / 24.0;
            DJ2012A += DJ2012[m2];
            DJ2214[m2] = DJ2214[m2] / 24.0;
            DJ2214A += DJ2214[m2];
            DJG[m2] = DJG[m2] / 24.0;
            DJGA += DJG[m2];
            TAmin = Math.min(TAmin, TMmin[m2]);
            TAmax = Math.max(TAmax, TMmax[m2]);
            TAsum += TMsum[m2];
            GAsum += GMsum[m2];
            DAsum += DMsum[m2];
            WVAmax = Math.max(WVAmax, WVMmax[m2]);
            WVAsum += WVMsum[m2];
            WEAsum += WEMsum[m2];
            WHAsum += WHMsum[m2];
            DNDAsum += DNDMsum[m2];
            DNCAsum += DNCMsum[m2];
            DNNAsum += DNNMsum[m2];
            DNAAsum += DNAMsum[m2];
            DNXAsum += DNXMsum[m2];
            int g = 0;
            while (g < this.stratLabel.length) {
                this.tableau[m2][g] = this.comptesGrp[g];
                this.comptesGrp[g] = 0;
                ++g;
            }
            ++m2;
        }
        if (count > 0.0) {
            TAavg = TAsum / count;
            WVAavg = WVAsum / count;
        } else {
            TAavg = 0.0;
            TAmin = 0.0;
            TAmax = 0.0;
            GAsum = 0.0;
            DAsum = 0.0;
            WVAmax = 0.0;
            WVAavg = 0.0;
            WEAsum = 0.0;
            WHAsum = 0.0;
        }
        this.txtClimate[0] = String.valueOf(this.english ? "Climate station : " : "Station climatique : ") + this.stationName + " (" + this.stationCountry + ")";
        this.txtClimate[1] = String.valueOf(this.english ? "Latitude  : " : "Latitude  : ") + this.stationLat + "\u00ba";
        this.txtClimate[2] = String.valueOf(this.english ? "Longitude : " : "Longitude : ") + this.stationLon + "\u00ba";
        this.txtClimate[3] = String.valueOf(this.english ? "Altitude  : " : "Altitude  : ") + this.stationAlt + " m";
        this.txtClimate[3] = String.valueOf(this.english ? "Temp Offset  : " : "Offset temp  : ") + String.format("%1.1f", this.ICUtempOffset) + " K";
        this.txtClimate[4] = "                       J     F     M     A     M     J     J     A     S     O     N     D       a";
        this.txtClimate[5] = this.english ? "T max month     : " : "T max mensuelle : ";
        this.txtClimate[6] = this.english ? "T avg month     : " : "T moy mensuelle : ";
        this.txtClimate[7] = this.english ? "T min month     : " : "T min mensuelle : ";
        this.txtClimate[8] = " ";
        this.txtClimate[9] = this.english ? "HDD 22/14       : " : "DJ ch 22/14     : ";
        this.txtClimate[10] = this.english ? "HDD 20/12       : " : "DJ ch 20/12     : ";
        this.txtClimate[11] = this.english ? "HDD 18/10       : " : "DJ ch 18/10     : ";
        this.txtClimate[12] = this.english ? "FrostDD <0\u00baC    : " : "DJ gel <0\u00baC     : ";
        m2 = 1;
        while (m2 < 13) {
            String tx = this.selectMonth[m2 - 1] ? String.format("%5.1f", TMmax[m2]) : "    .";
            this.txtClimate[5] = String.valueOf(this.txtClimate[5]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.1f", TMavg[m2]) : "    .";
            this.txtClimate[6] = String.valueOf(this.txtClimate[6]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.1f", TMmin[m2]) : "    .";
            this.txtClimate[7] = String.valueOf(this.txtClimate[7]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DJ2214[m2]) : "    .";
            this.txtClimate[9] = String.valueOf(this.txtClimate[9]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DJ2012[m2]) : "    .";
            this.txtClimate[10] = String.valueOf(this.txtClimate[10]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DJ1810[m2]) : "    .";
            this.txtClimate[11] = String.valueOf(this.txtClimate[11]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DJG[m2]) : "    .";
            this.txtClimate[12] = String.valueOf(this.txtClimate[12]) + " " + tx;
            ++m2;
        }
        this.txtClimate[5] = String.valueOf(this.txtClimate[5]) + " : " + String.format("%5.1f", TAmax) + " \u00baC";
        this.txtClimate[6] = String.valueOf(this.txtClimate[6]) + " : " + String.format("%5.1f", TAavg) + " \u00baC";
        this.txtClimate[7] = String.valueOf(this.txtClimate[7]) + " : " + String.format("%5.1f", TAmin) + " \u00baC";
        this.txtClimate[9] = String.valueOf(this.txtClimate[9]) + " : " + String.format("%5.0f", DJ2214A) + " dK";
        this.txtClimate[10] = String.valueOf(this.txtClimate[10]) + " : " + String.format("%5.0f", DJ2012A) + " dK";
        this.txtClimate[11] = String.valueOf(this.txtClimate[11]) + " : " + String.format("%5.0f", DJ1810A) + " dK";
        this.txtClimate[12] = String.valueOf(this.txtClimate[12]) + " : " + String.format("%5.0f", DJGA) + " dK";
        this.txtDaynight[0] = this.txtClimate[0];
        this.txtDaynight[1] = this.txtClimate[1];
        this.txtDaynight[2] = this.txtClimate[2];
        this.txtDaynight[3] = this.txtClimate[3];
        this.txtDaynight[4] = this.txtClimate[4];
        this.txtDaynight[5] = this.english ? "Daylight hours  : " : "Heures de jour  : ";
        this.txtDaynight[6] = this.english ? "Civil twiligth  : " : "Cr\u00e9puscule civil: ";
        this.txtDaynight[7] = this.english ? "Nautical ''     : " : " '' nautique    : ";
        this.txtDaynight[8] = this.english ? "Astronomical '' : " : " '' astro       : ";
        this.txtDaynight[9] = this.english ? "Dark            : " : "Nuit            : ";
        m2 = 1;
        while (m2 < 13) {
            String tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DNDMsum[m2]) : "    .";
            this.txtDaynight[5] = String.valueOf(this.txtDaynight[5]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DNCMsum[m2]) : "    .";
            this.txtDaynight[6] = String.valueOf(this.txtDaynight[6]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DNNMsum[m2]) : "    .";
            this.txtDaynight[7] = String.valueOf(this.txtDaynight[7]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DNAMsum[m2]) : "    .";
            this.txtDaynight[8] = String.valueOf(this.txtDaynight[8]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DNXMsum[m2]) : "    .";
            this.txtDaynight[9] = String.valueOf(this.txtDaynight[9]) + " " + tx;
            ++m2;
        }
        this.txtDaynight[5] = String.valueOf(this.txtDaynight[5]) + " h " + String.format("%5.0f", DNDAsum / 8760.0 * 100.0) + " %";
        this.txtDaynight[6] = String.valueOf(this.txtDaynight[6]) + " h " + String.format("%5.0f", DNCAsum / 8760.0 * 100.0) + " %";
        this.txtDaynight[7] = String.valueOf(this.txtDaynight[7]) + " h " + String.format("%5.0f", DNNAsum / 8760.0 * 100.0) + " %";
        this.txtDaynight[8] = String.valueOf(this.txtDaynight[8]) + " h " + String.format("%5.0f", DNAAsum / 8760.0 * 100.0) + " %";
        this.txtDaynight[9] = String.valueOf(this.txtDaynight[9]) + " h " + String.format("%5.0f", DNXAsum / 8760.0 * 100.0) + " %";
        this.txtSun[0] = this.txtClimate[0];
        this.txtSun[1] = this.txtClimate[1];
        this.txtSun[2] = this.txtClimate[2];
        this.txtSun[3] = this.txtClimate[3];
        this.txtSun[4] = this.txtClimate[4];
        this.txtSun[5] = this.english ? "Global hor.     : " : "Global hor.     : ";
        this.txtSun[6] = this.english ? "Diffuse hor.    : " : "Diffus hor.     : ";
        m2 = 1;
        while (m2 < 13) {
            String tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", GMsum[m2] / 1000.0) : "    .";
            this.txtSun[5] = String.valueOf(this.txtSun[5]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", DMsum[m2] / 1000.0) : "    .";
            this.txtSun[6] = String.valueOf(this.txtSun[6]) + " " + tx;
            ++m2;
        }
        this.txtSun[5] = String.valueOf(this.txtSun[5]) + " : " + String.format("%5.0f", GAsum / 1000.0) + " kWh/m2";
        this.txtSun[6] = String.valueOf(this.txtSun[6]) + " : " + String.format("%5.0f", DAsum / 1000.0) + " kWh/m2";
        this.txtWind[0] = this.txtClimate[0];
        this.txtWind[1] = this.txtClimate[1];
        this.txtWind[2] = this.txtClimate[2];
        this.txtWind[3] = this.txtClimate[3];
        this.txtWind[4] = this.txtClimate[4];
        this.txtWind[5] = this.english ? "Vmax month      : " : "Vmax mensuel    : ";
        this.txtWind[6] = this.english ? "Vavg month      : " : "Vmoy mensuel    : ";
        this.txtWind[7] = this.english ? "Epot generator  : " : "Epot \u00e9olienne   : ";
        this.txtWind[8] = this.english ? "4 < V < 25 m/s  : " : "4 < V < 25 m/s  : ";
        this.txtWind[9] = this.english ? "                  " : "                  ";
        m2 = 1;
        while (m2 < 13) {
            String tx = this.selectMonth[m2 - 1] ? String.format("%5.1f", WVMmax[m2]) : "    .";
            this.txtWind[5] = String.valueOf(this.txtWind[5]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.1f", WVMavg[m2]) : "    .";
            this.txtWind[6] = String.valueOf(this.txtWind[6]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.1f", WEMsum[m2] / 1000.0) : "    .";
            this.txtWind[7] = String.valueOf(this.txtWind[7]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", WHMsum[m2]) : "    .";
            this.txtWind[8] = String.valueOf(this.txtWind[8]) + " " + tx;
            tx = this.selectMonth[m2 - 1] ? String.format("%5.0f", WHMsum[m2] / (double)(this.joursMois[m2 - 1] * 24) * 100.0) : "    .";
            this.txtWind[9] = String.valueOf(this.txtWind[9]) + " " + tx;
            ++m2;
        }
        this.txtWind[5] = String.valueOf(this.txtWind[5]) + " : " + String.format("%5.1f", WVAmax) + " m/s";
        this.txtWind[6] = String.valueOf(this.txtWind[6]) + " : " + String.format("%5.1f", WVAavg) + " m/s";
        this.txtWind[7] = String.valueOf(this.txtWind[7]) + " : " + String.format("%5.0f", WEAsum / 1000.0) + " kWh/m2";
        this.txtWind[8] = String.valueOf(this.txtWind[8]) + " : " + String.format("%5.0f", WHAsum) + " h";
        this.txtWind[9] = String.valueOf(this.txtWind[9]) + " : " + String.format("%5.0f", WHAsum / 8760.0 * 100.0) + " %";
        this.txtHours[0] = this.titleHours;
        String tab = "";
        int strategy = 0;
        while (strategy < this.stratLabel.length) {
            double sum = 0.0;
            this.txtHours[strategy + 1] = String.valueOf(this.stratLabel[strategy]) + ":";
            month = 1;
            while (month < 13) {
                tab = this.tableau[month][strategy] < 10 ? "  " : (this.tableau[month][strategy] < 100 ? " " : "");
                this.txtHours[strategy + 1] = String.valueOf(this.txtHours[strategy + 1]) + " " + tab + this.tableau[month][strategy];
                sum += (double)this.tableau[month][strategy];
                this.valHours[month][strategy + 1] = String.valueOf(this.tableau[month][strategy]);
                ++month;
            }
            this.txtHours[strategy + 1] = String.valueOf(this.txtHours[strategy + 1]) + "  : " + String.format("%4.0f", sum);
            ++strategy;
        }
        this.txtPercent[0] = this.titlePercent;
        strategy = 0;
        while (strategy < this.stratLabel.length) {
            double sum = 0.0;
            this.txtPercent[strategy + 1] = String.valueOf(this.stratLabel[strategy]) + ":";
            month = 1;
            while (month < 13) {
                double val = (double)this.tableau[month][strategy] / (double)(this.joursMois[month - 1] * 24) * 100.0;
                this.txtPercent[strategy + 1] = String.valueOf(this.txtPercent[strategy + 1]) + " " + String.format("%3.0f", val);
                this.valPercent[month][strategy + 1] = String.format("%3.0f", val);
                sum += (double)this.tableau[month][strategy];
                ++month;
            }
            this.txtPercent[strategy + 1] = String.valueOf(this.txtPercent[strategy + 1]) + "  :  " + String.format("%2.0f", sum / 8760.0 * 100.0) + "%";
            ++strategy;
        }
        this.txtAnalysis[0] = this.titleAnalysis;
        strategy = 0;
        while (strategy < this.stratLabel.length) {
            this.txtAnalysis[strategy + 1] = String.valueOf(this.stratLabel[strategy]) + ":";
            int month2 = 1;
            while (month2 < 13) {
                tab = (double)this.tableau[month2][strategy] * this.stratProperties[strategy][0] / 3.0 > 600.0 ? "+++" : ((double)this.tableau[month2][strategy] * this.stratProperties[strategy][0] / 3.0 > 310.0 ? " ++" : ((double)this.tableau[month2][strategy] * this.stratProperties[strategy][0] / 3.0 > 144.0 ? "  +" : "  -"));
                this.txtAnalysis[strategy + 1] = String.valueOf(this.txtAnalysis[strategy + 1]) + " " + tab;
                this.valAnalysis[month2][strategy + 1] = tab;
                ++month2;
            }
            this.txtAnalysis[strategy + 1] = String.valueOf(this.txtAnalysis[strategy + 1]) + "  :    " + this.stratProperties[strategy][0];
            ++strategy;
        }
    }

    private int[] testStrategy(double T, double H) {
        double[] res = this.transform(T, H);
        double xPoint = res[0];
        double yPoint = res[1];
        boolean[] test = new boolean[this.droites.length];
        int d = 0;
        while (d < this.droites.length) {
            this.c0 = this.transform(this.droites[d][2], this.droites[d][3]);
            this.c1 = this.transform(this.droites[d][4], this.droites[d][5]);
            double dx = Math.max(this.c1[0] - this.c0[0], 0.01);
            double dy = this.c1[1] - this.c0[1];
            double a = dy / dx;
            double b = this.c0[1] - a * this.c0[0];
            double yDroite = a * xPoint + b;
            double xDroite = (yPoint - b) / a;
            test[d] = false;
            if (this.droites[d][6] == 0.0) {
                if (xPoint < xDroite) {
                    test[d] = true;
                }
            } else if (this.droites[d][6] == 1.0) {
                if (xPoint >= xDroite) {
                    test[d] = true;
                }
            } else if (this.droites[d][6] == 2.0) {
                if (yPoint < yDroite) {
                    test[d] = true;
                }
            } else if (this.droites[d][6] == 3.0 && yPoint >= yDroite) {
                test[d] = true;
            }
            ++d;
        }
        double[] cntIDd = new double[this.droites.length];
        double[] cntIDp = new double[this.droites.length];
        int d2 = 0;
        while (d2 < this.droites.length) {
            cntIDd[d2] = 0.0;
            cntIDp[d2] = 0.0;
            ++d2;
        }
        d2 = 0;
        while (d2 < this.droites.length) {
            int id;
            int n = id = (int)this.droites[d2][0];
            cntIDd[n] = cntIDd[n] + 1.0;
            if (test[d2]) {
                int n2 = id;
                cntIDp[n2] = cntIDp[n2] + 1.0;
            }
            ++d2;
        }
        d2 = 0;
        int[] cnt = new int[this.stratProperties.length];
        d2 = 0;
        while (d2 < cnt.length) {
            cnt[d2] = 0;
            ++d2;
        }
        int id = 0;
        while (id < this.droites.length) {
            if (cntIDd[id] > 0.0 && cntIDd[id] == cntIDp[id]) {
                d2 = 0;
                while (d2 < this.droites.length) {
                    if (this.droites[d2][0] == (double)id) {
                        int n = (int)this.droites[d2][1];
                        cnt[n] = cnt[n] + 1;
                        break;
                    }
                    ++d2;
                }
            }
            ++id;
        }
        return cnt;
    }

    private double[] transform(double T, double H) {
        double Patm = 101325.0;
        double Psat = 0.0;
        double W = 0.0;
        Psat = T <= 0.0 ? 3.61633E12 * Math.exp(-6150.6 / (T + 273.33)) : 1.40974E10 * Math.exp(-3928.5 / (T + 231.667));
        W = 0.62198 * H / 100.0 * Psat / (Patm - H / 100.0 * Psat);
        double px = (double)this.x2 / (this.ex1[this.zoomMode] - this.ex0[this.zoomMode]);
        double py = (double)this.y2 / (this.ey1[this.zoomMode] - this.ey0[this.zoomMode]);
        int x = this.x1 + (int)(px * (T - this.ex0[this.zoomMode]));
        int y = this.y1 + this.y2 - (int)(py * W);
        double[] result = new double[]{x, y};
        return result;
    }

    private String dateReverse(int xPos, int yPos) {
        int doy = (int)(((double)xPos - (double)this.x1T) / (double)this.x2T * 365.0);
        int hod = (int)(((double)this.y1T + (double)this.y2T - (double)yPos) / (double)this.y2T * 24.0);
        int mm = 0;
        mm = 0;
        while (mm < this.JM.length) {
            if (doy < this.JM[mm]) break;
            ++mm;
        }
        String result = String.valueOf(doy - this.JM[mm - 1] + 1) + " " + this.nomMois[mm - 1] + " : " + hod + "h";
        return result;
    }

    private String dataReverse(double TT, double HH) {
        double tolT = 0.2;
        double tolH = 2.0;
        boolean foundFlag = false;
        int h = 0;
        while (h < this.T.length) {
            if (Math.abs(this.T[h] - TT) < tolT && Math.abs(this.H[h] - HH) < tolH) {
                foundFlag = true;
                break;
            }
            ++h;
        }
        int doy = (int)Math.floor(h / 24);
        int hour = h - doy * 24;
        int day = 0;
        int mm = 0;
        while (mm < this.joursMois.length) {
            if (doy < day) {
                day -= this.joursMois[mm - 1];
                break;
            }
            day += this.joursMois[mm];
            ++mm;
        }
        String result = null;
        result = foundFlag ? String.valueOf(doy - day + 1) + " " + this.nomMois[mm - 1] + " : " + hour + "h" : null;
        return result;
    }

    private double[] transformReverse(int xPos, int yPos) {
        double Patm = 101325.0;
        double Psat = 0.0;
        double px = (double)this.x2 / (this.ex1[this.zoomMode] - this.ex0[this.zoomMode]);
        double py = (double)this.y2 / (this.ey1[this.zoomMode] - this.ey0[this.zoomMode]);
        double T = (double)(xPos - this.x1) / px + this.ex0[this.zoomMode];
        Psat = T <= 0.0 ? 3.61633E12 * Math.exp(-6150.6 / (T + 273.33)) : 1.40974E10 * Math.exp(-3928.5 / (T + 231.667));
        double W = (double)(this.y1 + this.y2 - yPos) / py;
        double H = 100.0 * (W * Patm / (Psat * (0.62198 + W)));
        double Td = this.getT_dew(T, H);
        double[] result = new double[]{T, H, Td};
        return result;
    }

    private double[] transformReverseT(int xPos, int yPos) {
        int day = (int)(((double)xPos - (double)this.x1T) / (double)this.x2T * 365.0);
        int hod = (int)(((double)this.y1T + (double)this.y2T - (double)yPos) / (double)this.y2T * 24.0);
        int hoy = day * 24 + hod;
        double val0 = 0.0;
        double val1 = 0.0;
        double val2 = 0.0;
        if (this.displayMode == 4) {
            val0 = this.T[hoy];
            val1 = this.H[hoy];
            val2 = this.getT_dew(this.T[hoy], this.H[hoy]);
        } else if (this.displayMode == 5) {
            transPos transpos = null;
            transpos = new transPos();
            double[] res = transpos.getHCAZ(Math.toRadians(Double.parseDouble(this.stationLat)), hoy);
            val0 = Math.round(Math.toDegrees(res[0]));
            val1 = Math.round(Math.toDegrees(res[1]));
        } else if (this.displayMode == 6) {
            val0 = this.G[hoy];
            val1 = this.D[hoy];
        } else if (this.displayMode == 7 || this.displayMode == 8) {
            val0 = this.Wv[hoy];
            val1 = this.Wd[hoy];
        }
        double[] res = new double[]{val0, val1, val2};
        return res;
    }

    private double getT_dew(double T, double HR) {
        double Td;
        if (T > 0.0) {
            double p_sat = 1.40574 * Math.pow(10.0, 10.0) * Math.exp(-3928.5 / (T + 231.667));
            double p_prt = p_sat * HR / 100.0;
            Td = -3928.5 / Math.log(p_prt / (1.40574 * Math.pow(10.0, 10.0))) - 231.667;
        } else {
            double p_sat = 3.61633 * Math.pow(10.0, 12.0) * Math.exp(-6150.0 / (T + 273.33));
            double p_prt = p_sat * HR / 100.0;
            Td = -6150.6 / Math.log(p_prt / (3.61633 * Math.pow(10.0, 12.0))) - 273.33;
        }
        return Td;
    }

    private String openDlg(String dlgTitle, String fileExtension) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(dlgTitle);
        chooser.setCurrentDirectory(this.fileDirectory);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(String.valueOf(fileExtension) + " files", fileExtension);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            String selectedFile = chooser.getSelectedFile().getPath();
            this.fileDirectory = chooser.getSelectedFile();
            if (selectedFile != null) {
                this.ClimateFn = selectedFile;
            }
        }
        System.out.println("selected file = " + this.ClimateFn);
        return this.ClimateFn;
    }

    private String saveDlg(String dlgTitle, String fileExtension) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(dlgTitle);
        chooser.setSelectedFile(new File("output"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(String.valueOf(fileExtension) + " files", fileExtension);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(null);
        String selectedFile = null;
        if (returnVal == 0) {
            selectedFile = chooser.getSelectedFile().getPath();
        }
        System.out.println("selected file = " + selectedFile);
        return selectedFile;
    }

    private void readFile(String fileName, String fileFormat) {
        try {
            String inFileName = fileName;
            FileInputStream infstream = new FileInputStream(inFileName);
            DataInputStream in = new DataInputStream(infstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            if (fileFormat.equals("dat")) {
                String strLine;
                String fileSeparator = ";";
                int c = 0;
                while ((strLine = br.readLine()) != null) {
                    String[] fields = strLine.split(fileSeparator, -1);
                    if (fields[0].equals("#")) continue;
                    if (c < 7) {
                        if (strLine == null) continue;
                        if (fields[0].equals("stationName")) {
                            this.stationName = fields[1];
                        } else if (fields[0].equals("stationState")) {
                            this.stationState = fields[1];
                        } else if (fields[0].equals("stationCountry")) {
                            this.stationCountry = fields[1];
                        } else if (fields[0].equals("stationLat")) {
                            this.stationLat = fields[1];
                            this.stationLatVal = Double.parseDouble(this.stationLat);
                        } else if (fields[0].equals("stationLon")) {
                            this.stationLon = fields[1];
                            this.stationLonVal = Double.parseDouble(this.stationLon);
                        } else if (fields[0].equals("stationZone")) {
                            this.stationZone = fields[1];
                            this.stationZoneVal = Double.parseDouble(this.stationZone);
                        } else if (fields[0].equals("stationAlt")) {
                            this.stationAlt = fields[1];
                            this.userAltVal = this.stationAltVal = Double.parseDouble(this.stationAlt);
                        }
                        ++c;
                        continue;
                    }
                    int hh = Integer.parseInt(fields[1]);
                    this.M[hh] = Double.parseDouble(fields[0]);
                    this.T[hh] = Double.parseDouble(fields[2]);
                    this.H[hh] = Double.parseDouble(fields[3]);
                    this.G[hh] = Double.parseDouble(fields[4]);
                    this.D[hh] = Double.parseDouble(fields[5]);
                    this.Wd[hh] = Double.parseDouble(fields[6]);
                    this.Wv[hh] = Double.parseDouble(fields[7]);
                }
            } else if (fileFormat.equals("epw")) {
                String strLine;
                String fileSeparator = ",";
                int c = 0;
                while ((strLine = br.readLine()) != null) {
                    String[] fields = strLine.split(fileSeparator, -1);
                    if (c == 0) {
                        if (strLine != null) {
                            this.stationName = fields[1];
                            this.stationState = fields[2];
                            this.stationCountry = fields[3];
                            this.stationLat = fields[6];
                            this.stationLon = fields[7];
                            this.stationZone = fields[8];
                            this.stationAlt = fields[9];
                            this.stationLatVal = Double.parseDouble(this.stationLat);
                            this.stationLonVal = Double.parseDouble(this.stationLon);
                            this.stationZoneVal = Double.parseDouble(this.stationZone);
                            this.userAltVal = this.stationAltVal = Double.parseDouble(this.stationAlt);
                        }
                    } else if (c > 7) {
                        int hh = c - 8;
                        this.M[hh] = Double.parseDouble(fields[1]);
                        this.T[hh] = Double.parseDouble(fields[6]);
                        this.H[hh] = Double.parseDouble(fields[8]);
                        this.D[hh] = Double.parseDouble(fields[15]);
                        this.G[hh] = Double.parseDouble(fields[14]) + this.D[hh];
                        this.Wd[hh] = Double.parseDouble(fields[20]);
                        this.Wv[hh] = Double.parseDouble(fields[21]);
                        this.Cc[hh] = Double.parseDouble(fields[23]);
                        this.Pr[hh] = Double.parseDouble(fields[34]);
                    }
                    ++c;
                }
            }
            in.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
            System.err.println("Error: " + e.getMessage());
        }
    }

    private void writeFile(String txt, String OutputFn) {
        txt = this.composeTxt();
        if (txt != null) {
            try {
                FileWriter outfstream = new FileWriter(OutputFn);
                BufferedWriter out = new BufferedWriter(outfstream);
                out.write(txt);
                out.write("\nEOF");
                out.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
                System.err.println("Error: " + e.getMessage());
            }
            System.out.println("resultats disponibles dans output.dat");
        }
    }

    private String composeTxt() {
        String txt = String.valueOf(this.header) + "\n" + "\n";
        int i = 0;
        while (i < this.txtClimate.length) {
            txt = String.valueOf(txt) + this.txtClimate[i] + "\n";
            ++i;
        }
        txt = String.valueOf(txt) + "\n";
        i = 5;
        while (i < this.txtDaynight.length) {
            txt = String.valueOf(txt) + this.txtDaynight[i] + "\n";
            ++i;
        }
        txt = String.valueOf(txt) + "\n";
        i = 5;
        while (i < this.txtSun.length) {
            txt = String.valueOf(txt) + this.txtSun[i] + "\n";
            ++i;
        }
        txt = String.valueOf(txt) + "\n";
        i = 5;
        while (i < this.txtWind.length) {
            txt = String.valueOf(txt) + this.txtWind[i] + "\n";
            ++i;
        }
        txt = String.valueOf(txt) + "\n";
        txt = String.valueOf(txt) + this.title + "\n" + "\n";
        txt = String.valueOf(txt) + this.footer + "\n" + "\n";
        txt = String.valueOf(txt) + this.txtAnalysis[0] + "\n";
        int strategy = 0;
        while (strategy < this.stratProperties.length) {
            txt = String.valueOf(txt) + this.txtAnalysis[strategy + 1] + "\n";
            ++strategy;
        }
        txt = String.valueOf(txt) + this.legend1 + "\n" + this.legend2 + "\n" + "\n";
        txt = String.valueOf(txt) + this.txtPercent[0] + "\n";
        strategy = 0;
        while (strategy < this.stratProperties.length) {
            txt = String.valueOf(txt) + this.txtPercent[strategy + 1] + "\n";
            ++strategy;
        }
        txt = String.valueOf(txt) + "\n";
        txt = String.valueOf(txt) + this.txtHours[0] + "\n";
        strategy = 0;
        while (strategy < this.stratProperties.length) {
            txt = String.valueOf(txt) + this.txtHours[strategy + 1] + "\n";
            ++strategy;
        }
        txt = String.valueOf(txt) + "\n";
        txt = String.valueOf(txt) + "File name : " + this.ClimateFn + "\n";
        txt = String.valueOf(txt) + "Software  : " + this.appName + " " + this.appVersion + " (" + this.appBuild + ")" + "\n";
        return txt;
    }

    private String transformToHTML(String message) {
        String[] header = new String[]{"<html><body>", "</body></html>"};
        return String.valueOf(header[0]) + message + header[1];
    }

    public static void main(String[] args) {
        String ClimFn = "met_dummy.dat";
        if (args.length > 0) {
            ClimFn = args[0];
        }
        new climcad(ClimFn);
    }

    class graphDisplay
    extends Canvas {
        graphDisplay() {
        }

        @Override
        public void paint(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.setFont(climcad.this.tableFont);
            double[] res = new double[2];
            int[] x = new int[100];
            int[] y = new int[100];
            int centerX = climcad.this.imgX / 2;
            int centerY = climcad.this.imgY / 2 - 30;
            if (climcad.this.displayMode < 20) {
                climcad.this.jPa_0.setVisible(true);
                g.setColor(climcad.this.applicationBackgroundColor);
                g.fillRect(0, 0, centerX * 2 + 20, centerY * 2 + 30);
                if (climcad.this.displayMode < 4) {
                    int st = 2;
                    int xx = climcad.this.x1;
                    while (xx < climcad.this.x1 + climcad.this.x2) {
                        Color col = climcad.this.applicationBackgroundColor;
                        int yy = climcad.this.y2 + climcad.this.y1;
                        while (yy > climcad.this.y1) {
                            double[] result = climcad.this.transformReverse(xx, yy);
                            if (result[1] < 100.0) {
                                int[] strategies = climcad.this.testStrategy(result[0], result[1]);
                                int A = 0;
                                int R = 0;
                                int G = 0;
                                int B = 0;
                                int cnt = 0;
                                int i = 0;
                                while (i < strategies.length) {
                                    if ((i == climcad.this.stratMode || climcad.this.stratMode == 0) && strategies[i] == 1) {
                                        A = climcad.this.labelColor[i][3];
                                        R += climcad.this.labelColor[i][0] * A;
                                        G += climcad.this.labelColor[i][1] * A;
                                        B += climcad.this.labelColor[i][2] * A;
                                        cnt += A;
                                    }
                                    ++i;
                                }
                                if (cnt > 0) {
                                    col = climcad.this.displayMode == 0 ? new Color((R + G + B) / 3 / cnt, (R + G + B) / 3 / cnt, (R + G + B) / 3 / cnt) : new Color(R / cnt, G / cnt, B / cnt);
                                    g.setColor(col);
                                    g.drawLine(xx, yy, xx, yy);
                                }
                            }
                            yy -= st;
                        }
                        xx += st;
                    }
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                double H = 10.0;
                while (H <= 100.0) {
                    int i = 0;
                    double T = climcad.this.ex0[climcad.this.zoomMode];
                    while (T <= climcad.this.ex1[climcad.this.zoomMode]) {
                        res = climcad.this.transform(T, H);
                        x[i] = (int)res[0];
                        y[i] = (int)res[1];
                        ++i;
                        T += 1.0;
                    }
                    g.setColor(climcad.this.graphGridColor);
                    g.drawPolyline(x, y, i);
                    H += 10.0;
                }
                g.setColor(climcad.this.graphGridColor);
                g.fillRect(climcad.this.x1, climcad.this.y1 + climcad.this.y2, climcad.this.x2, 20);
                double T = climcad.this.ex0[climcad.this.zoomMode];
                while (T <= climcad.this.ex1[climcad.this.zoomMode]) {
                    double H2 = 100.0;
                    res = climcad.this.transform(T, H2);
                    g.setColor(climcad.this.graphGridColor);
                    g.drawLine((int)res[0], (int)res[1], (int)res[0], climcad.this.y1 + climcad.this.y2);
                    g.setFont(new Font("dialog", 0, 10));
                    g.setColor(climcad.this.graphLegendColor);
                    double xx = climcad.this.x1 + (int)((double)climcad.this.x2 / (climcad.this.ex1[climcad.this.zoomMode] - climcad.this.ex0[climcad.this.zoomMode]) * (T - climcad.this.ex0[climcad.this.zoomMode])) - 5;
                    g.drawString(String.valueOf(String.format("%.0f", T)) + "\u00baC", (int)xx, climcad.this.y1 + climcad.this.y2 + 13);
                    T += climcad.this.exi[climcad.this.zoomMode];
                }
                int i = 0;
                while (i < climcad.this.x2) {
                    double tt = (double)i / (double)climcad.this.x2 * (climcad.this.ex1[climcad.this.zoomMode] - climcad.this.ex0[climcad.this.zoomMode]) + climcad.this.ex0[climcad.this.zoomMode];
                    if (climcad.this.displayMode < 5 || climcad.this.displayMode == 9) {
                        g.setColor(climcad.this.getColorPal(tt, climcad.this.palette));
                    } else {
                        g.setColor(new Color(64, 64, 64));
                    }
                    g.drawLine(i + climcad.this.x1, climcad.this.y1 + climcad.this.y2, i + climcad.this.x1, climcad.this.y1 + climcad.this.y2 + 3);
                    ++i;
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                i = 0;
                while (i < climcad.this.T.length) {
                    double[] date = climcad.this.HOYtoDate(i);
                    if (climcad.this.selectMonth[(int)date[0] - 1]) {
                        res = climcad.this.transform(climcad.this.simTemp(climcad.this.T[i]), climcad.this.H[i]);
                        Color col = climcad.this.graphBackgroundColor;
                        if (climcad.this.displayMode == 5) {
                            double hc = climcad.this.transpos.getHC(Math.toRadians(climcad.this.stationLatVal), i);
                            col = climcad.this.getColorPal(Math.toDegrees(hc), 3);
                        } else if (climcad.this.displayMode == 6) {
                            col = climcad.this.getColorPal(climcad.this.G[i], 4);
                        } else if (climcad.this.displayMode == 7) {
                            col = climcad.this.getColorPal(climcad.this.Wv[i], 5);
                        } else if (climcad.this.displayMode == 8) {
                            if (climcad.this.Wv[i] > 0.0) {
                                col = climcad.this.getColorPal(climcad.this.Wd[i], 6);
                                int vMax = 8;
                                int r1 = (int)(Math.min(climcad.this.Wv[i], (double)vMax) / (double)vMax * (double)col.getRed());
                                int g1 = (int)(Math.min(climcad.this.Wv[i], (double)vMax) / (double)vMax * (double)col.getGreen());
                                int b1 = (int)(Math.min(climcad.this.Wv[i], (double)vMax) / (double)vMax * (double)col.getBlue());
                                col = new Color(r1, g1, b1);
                            }
                        } else {
                            col = climcad.this.displayMode == 10 ? climcad.this.getColorPal(climcad.this.Cc[i], 8) : climcad.this.getColor(climcad.this.T[i]);
                        }
                        g.setColor(col);
                        int size = 3;
                        g.drawOval((int)res[0] - size / 2, (int)res[1] - size / 2, size, size);
                    }
                    ++i;
                }
                System.out.println(String.valueOf(i) + " points dessines");
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (climcad.this.displayMode > 0 && climcad.this.displayMode < 4) {
                    g.setColor(climcad.this.tableColor);
                    g.setFont(new Font("dialog", 1, 10));
                    i = 0;
                    while (i < climcad.this.stratProperties.length) {
                        res = climcad.this.transform(climcad.this.stratProperties[i][1], climcad.this.stratProperties[i][2]);
                        String txt = String.format("%.0f", i);
                        int offSet = -2;
                        if (i < 10) {
                            txt = " " + txt;
                        }
                        if (climcad.this.stratProperties[i][2] > 100.0) {
                            txt = i < 12 ? "<" + txt : String.valueOf(txt) + " >";
                            offSet = 0;
                        }
                        g.setColor(climcad.this.graphBackgroundColor);
                        g.fillOval((int)res[0] + offSet, (int)res[1] - 5, 25, 12);
                        g.setColor(climcad.this.graphGridColor);
                        g.drawOval((int)res[0] + offSet, (int)res[1] - 5, 25, 12);
                        g.setColor(climcad.this.tableColor);
                        g.drawString(txt, (int)res[0] + 5, (int)res[1] + 5);
                        ++i;
                    }
                }
                g.setColor(climcad.this.graphBorderColor);
                g.fillRect(climcad.this.x1 + climcad.this.x2 - 26, climcad.this.y1, 26, climcad.this.y2 + 20);
                g.setFont(new Font("dialog", 0, 10));
                g.setColor(climcad.this.graphLegendColor);
                double H3 = 10.0;
                while (H3 <= 100.0) {
                    res = climcad.this.transform(climcad.this.ex1[climcad.this.zoomMode], H3);
                    g.drawString(String.valueOf(String.format("%.0f", H3)) + "%", climcad.this.x1 + climcad.this.x2 - 24, (int)res[1] + 10);
                    H3 += 10.0;
                }
                g.setFont(climcad.this.tableFont);
                g.setColor(climcad.this.tableColor);
                if (climcad.this.displayMode == 0) {
                    g.setFont(new Font("dialog", 1, 16));
                    g.drawString(climcad.this.appAboutHeader, climcad.this.x1 + 5, climcad.this.y1 + 20);
                    g.setFont(climcad.this.tableFont);
                    int k = 0;
                    while (k < climcad.this.appAboutBody.length) {
                        g.drawString(climcad.this.appAboutBody[k], climcad.this.x1 + 5, climcad.this.y1 + k * 10 + 35);
                        ++k;
                    }
                    g.drawString(String.valueOf(climcad.this.english ? "File name : " : "Nom de fichier : ") + climcad.this.ClimateFn, climcad.this.x1 + 5, climcad.this.y1 + k * 10 + 45);
                    int xx = climcad.this.x1 + 5;
                    int yy = climcad.this.y1 + (k + 1) * 10 + 45;
                    g.drawString(String.valueOf(climcad.this.english ? "Station name : " : "Nom de la station : ") + climcad.this.stationName + " (" + climcad.this.stationCountry + ")", xx, yy);
                    g.drawString(String.valueOf(climcad.this.english ? "Latitude  : " : "Latitude  : ") + climcad.this.stationLat + "\u00ba", xx, yy + 10);
                    g.drawString(String.valueOf(climcad.this.english ? "Longitude : " : "Longitude : ") + climcad.this.stationLon + "\u00ba", xx, yy + 20);
                    g.drawString(String.valueOf(climcad.this.english ? "Altitude  : " : "Altitude  : ") + climcad.this.stationAlt + " m", xx, yy + 30);
                    g.drawString(String.valueOf(climcad.this.english ? "Temp correction : " : "Correction temp : ") + String.format("%1.1f", climcad.this.ICUtempOffset - (climcad.this.userAltVal - climcad.this.stationAltVal) / 100.0 * 0.65) + " K", xx, yy + 40);
                } else if (climcad.this.displayMode > 0 && climcad.this.displayMode < 4) {
                    int strategy = 0;
                    while (strategy < climcad.this.stratProperties.length) {
                        Color col = climcad.this.applicationBackgroundColor;
                        int month = 1;
                        while (month < 13) {
                            if (climcad.this.displayMode == 1) {
                                if ((double)climcad.this.tableau[month][strategy] * climcad.this.stratProperties[strategy][0] / 3.0 > 600.0) {
                                    col = Color.red;
                                } else if ((double)climcad.this.tableau[month][strategy] * climcad.this.stratProperties[strategy][0] / 3.0 > 310.0) {
                                    col = Color.yellow;
                                } else if ((double)climcad.this.tableau[month][strategy] * climcad.this.stratProperties[strategy][0] / 3.0 > 144.0) {
                                    col = Color.green;
                                } else {
                                    col = climcad.this.applicationBackgroundColor;
                                    if (strategy % 2 == 0) {
                                        col = new Color(64, 64, 64);
                                    }
                                }
                            } else {
                                col = climcad.this.displayMode == 2 ? climcad.this.getColorPal(climcad.this.tableau[month][strategy], 7) : climcad.this.getColorPal(climcad.this.tableau[month][strategy], 7);
                            }
                            g.setColor(col);
                            g.fillRect(climcad.this.x1S + (month - 1) * climcad.this.x2S / 12, climcad.this.y1S + strategy * climcad.this.y2S / climcad.this.stratLabel.length + 5, climcad.this.x2S / 12 + 1, climcad.this.y2S / climcad.this.stratLabel.length + 1);
                            ++month;
                        }
                        col = strategy % 2 == 0 ? new Color(64, 64, 64) : climcad.this.applicationBackgroundColor;
                        g.setColor(col);
                        g.fillRect(climcad.this.x1 + 5, climcad.this.y1S + strategy * climcad.this.y2S / climcad.this.stratLabel.length + 5, 255, climcad.this.y2S / climcad.this.stratLabel.length + 1);
                        ++strategy;
                    }
                    g.setColor(climcad.this.tableColor);
                    if (climcad.this.displayMode == 1) {
                        g.drawString(climcad.this.titleAnalysis, climcad.this.x1 + 5, climcad.this.y1 + 12);
                    } else if (climcad.this.displayMode == 2) {
                        g.drawString(climcad.this.titlePercent, climcad.this.x1 + 5, climcad.this.y1 + 12);
                    } else if (climcad.this.displayMode == 3) {
                        g.drawString(climcad.this.titleHours, climcad.this.x1 + 5, climcad.this.y1 + 12);
                    }
                    String[] mList = new String[]{"J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"};
                    int month = 0;
                    while (month < 12) {
                        g.drawString(mList[month], climcad.this.x1S + month * climcad.this.x2S / 12 + 10, climcad.this.y1 + 12);
                        ++month;
                    }
                    strategy = 1;
                    while (strategy < climcad.this.txtAnalysis.length) {
                        g.setColor(climcad.this.tableColor);
                        g.drawString(climcad.this.stratLabel[strategy - 1], climcad.this.x1 + 5, climcad.this.y1 + strategy * 10 + 20);
                        month = 0;
                        while (month < 12) {
                            if (climcad.this.displayMode == 1) {
                                g.drawString(climcad.this.valAnalysis[month + 1][strategy], climcad.this.x1S + month * climcad.this.x2S / 12 + 5, climcad.this.y1 + strategy * 10 + 20);
                            } else if (climcad.this.displayMode == 2) {
                                g.drawString(climcad.this.valPercent[month + 1][strategy], climcad.this.x1S + month * climcad.this.x2S / 12 + 5, climcad.this.y1 + strategy * 10 + 20);
                            } else if (climcad.this.displayMode == 3) {
                                g.drawString(climcad.this.valHours[month + 1][strategy], climcad.this.x1S + month * climcad.this.x2S / 12 + 5, climcad.this.y1 + strategy * 10 + 20);
                            }
                            ++month;
                        }
                        ++strategy;
                    }
                    if (climcad.this.displayMode == 1) {
                        g.drawString(climcad.this.legend1, climcad.this.x1 + 5, climcad.this.y1 + strategy * 10 + 25);
                    } else if (climcad.this.displayMode == 3) {
                        g.drawString(climcad.this.legend0, climcad.this.x1 + 5, climcad.this.y1 + strategy * 10 + 25);
                    }
                    g.drawString(String.valueOf(climcad.this.english ? "Temp correction : " : "Correction temp : ") + String.format("%1.1f", climcad.this.ICUtempOffset - (climcad.this.userAltVal - climcad.this.stationAltVal) / 100.0 * 0.65) + " K", climcad.this.x1 + 5, climcad.this.y1 + strategy * 10 + 35);
                    if (climcad.this.GIECdate > 0) {
                        String txt = climcad.this.english ? "Climate " : "Climat ";
                        String[] txtGIECdate = new String[]{"present ", "2040 : ", "2060 : ", "2100 : "};
                        String[] txtGIECssp = new String[]{"SSP1-1.9", "SSP1-2.6", "SSP2-4.5", "SSP3-7.0", "SSP5-8.5"};
                        txt = String.valueOf(txt) + txtGIECdate[climcad.this.GIECdate] + (climcad.this.english ? "scenario " : "sc\u00e9nario ") + txtGIECssp[climcad.this.GIECssp];
                        g.drawString(txt, climcad.this.x1 + 5, climcad.this.y1 + strategy * 11 + 35);
                    }
                } else if (climcad.this.displayMode > 3 && climcad.this.displayMode < 9 || climcad.this.displayMode == 10) {
                    int k;
                    if (climcad.this.displayMode == 4) {
                        k = 0;
                        while (k < climcad.this.txtClimate.length) {
                            g.drawString(climcad.this.txtClimate[k], climcad.this.x1 + 5, climcad.this.y1 + k * 10 + 15);
                            ++k;
                        }
                    } else if (climcad.this.displayMode == 5) {
                        k = 0;
                        while (k < climcad.this.txtDaynight.length) {
                            g.drawString(climcad.this.txtDaynight[k], climcad.this.x1 + 5, climcad.this.y1 + k * 10 + 15);
                            ++k;
                        }
                    } else if (climcad.this.displayMode == 6 || climcad.this.displayMode == 10) {
                        k = 0;
                        while (k < climcad.this.txtSun.length) {
                            g.drawString(climcad.this.txtSun[k], climcad.this.x1 + 5, climcad.this.y1 + k * 10 + 15);
                            ++k;
                        }
                    } else {
                        k = 0;
                        while (k < climcad.this.txtWind.length) {
                            g.drawString(climcad.this.txtWind[k], climcad.this.x1 + 5, climcad.this.y1 + k * 10 + 15);
                            ++k;
                        }
                    }
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    double step = 1.0;
                    double j = 0.0;
                    while (j < 8760.0) {
                        double[] date = climcad.this.HOYtoDate(j);
                        double xx = (double)climcad.this.x1T + Math.floor(j / 24.0) * (double)climcad.this.x2T / 365.0;
                        double yy = (double)(climcad.this.y1T + climcad.this.y2T) - (j - Math.floor(j / 24.0) * 24.0) * (double)climcad.this.y2T / 24.0;
                        Color col = climcad.this.graphBackgroundColor;
                        if (climcad.this.displayMode == 4) {
                            col = climcad.this.getColor(climcad.this.T[(int)j]);
                        } else if (climcad.this.displayMode == 5) {
                            double hc = Math.toDegrees(climcad.this.transpos.getHC(Math.toRadians(Double.parseDouble(climcad.this.stationLat)), j));
                            col = climcad.this.getColorPal(hc, 3);
                        } else if (climcad.this.displayMode == 6) {
                            col = climcad.this.getColorPal(climcad.this.G[(int)j], 4);
                        } else if (climcad.this.displayMode == 7) {
                            col = climcad.this.getColorPal(climcad.this.Wv[(int)j], 5);
                        } else if (climcad.this.displayMode == 8) {
                            if (climcad.this.Wv[(int)j] > 0.0) {
                                col = climcad.this.getColorPal(climcad.this.Wd[(int)j], 6);
                                int vMax = 8;
                                int r1 = (int)(Math.min(climcad.this.Wv[(int)j], (double)vMax) / (double)vMax * (double)col.getRed());
                                int g1 = (int)(Math.min(climcad.this.Wv[(int)j], (double)vMax) / (double)vMax * (double)col.getGreen());
                                int b1 = (int)(Math.min(climcad.this.Wv[(int)j], (double)vMax) / (double)vMax * (double)col.getBlue());
                                col = new Color(r1, g1, b1);
                            }
                        } else if (climcad.this.displayMode == 10) {
                            col = climcad.this.getColorPal(climcad.this.Cc[(int)j], 8);
                        }
                        if (climcad.this.selectMonth[(int)date[0] - 1]) {
                            g.setColor(col);
                        } else {
                            int sx = (col.getRed() + col.getGreen() + col.getBlue()) / 3;
                            g.setColor(new Color(sx, sx, sx));
                        }
                        g.drawRect((int)xx, (int)yy, 1, 4);
                        j += step;
                    }
                    if (climcad.this.displayMode == 8) {
                        int x1E = 20;
                        int y1E = 300;
                        int x2E = 80;
                        int y2E = 80;
                        int vMax = 8;
                        double r = 2.0;
                        while (r < (double)vMax) {
                            double a = 0.0;
                            while (a < 360.0) {
                                double xp = (double)(x1E + x2E / 2) + Math.sin(Math.toRadians(a)) * (double)x2E * r / (double)vMax / 2.0;
                                double yp = (double)(y1E + y2E / 2) - Math.cos(Math.toRadians(a)) * (double)y2E * r / (double)vMax / 2.0;
                                double xq = (double)(x1E + x2E / 2) + Math.sin(Math.toRadians(a)) * (double)x2E * (r - 1.0) / (double)vMax / 2.0;
                                double yq = (double)(y1E + y2E / 2) - Math.cos(Math.toRadians(a)) * (double)y2E * (r - 1.0) / (double)vMax / 2.0;
                                Color col = climcad.this.getColorPal(a, 6);
                                int r1 = (int)(r / (double)vMax * (double)col.getRed());
                                int g1 = (int)(r / (double)vMax * (double)col.getGreen());
                                int b1 = (int)(r / (double)vMax * (double)col.getBlue());
                                col = new Color(r1, g1, b1);
                                g.setColor(col);
                                g.drawLine((int)xp, (int)yp, (int)xq, (int)yq);
                                a += 0.3;
                            }
                            r += 1.0;
                        }
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setColor(climcad.this.tableColor);
                        g.drawString("N", x1E + x2E / 2 - 3, y1E + 2);
                        g.drawString("S", x1E + x2E / 2 - 3, y1E + y2E + 5);
                        g.drawString("E", x1E + x2E, y1E + y2E / 2 + 4);
                        g.drawString(climcad.this.english ? "W" : "O", x1E - 6, y1E + y2E / 2 + 4);
                    }
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(climcad.this.tableColor);
                    g.drawString("0h", climcad.this.x1T - 15, climcad.this.y1T + climcad.this.y2T + 5);
                    g.drawString("12", climcad.this.x1T - 15, climcad.this.y1T + climcad.this.y2T / 2 + 5);
                    g.drawString("24", climcad.this.x1T - 15, climcad.this.y1T + 5);
                    String[] mShort = new String[]{"J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"};
                    double m = 0.0;
                    while (m < 12.0) {
                        g.drawString(mShort[(int)m], climcad.this.x1T + (int)m * climcad.this.x2T / 12 + climcad.this.x2T / 24 - 4, climcad.this.y1T + climcad.this.y2T + 15);
                        m += 1.0;
                    }
                } else if (climcad.this.displayMode == 9) {
                    int k = 0;
                    while (k < climcad.this.txtWind.length) {
                        g.drawString(climcad.this.txtWind[k], climcad.this.x1 + 5, climcad.this.y1 + k * 10 + 15);
                        ++k;
                    }
                    double rMax = 20.0;
                    int cInt = 5;
                    double r0 = 40.0;
                    double r1 = ((double)climcad.this.x2R - 2.0 * r0) / (2.0 * rMax);
                    g.setColor(climcad.this.graphBackgroundColor);
                    g.fillOval(climcad.this.x1R, climcad.this.y1R, climcad.this.x2R, climcad.this.y2R);
                    g.setColor(climcad.this.graphGridColor);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    double r = 0.0;
                    while (r < rMax + 1.0) {
                        g.drawOval((int)((double)(climcad.this.x1R + climcad.this.x2R / 2) - (r0 + r * r1)), (int)((double)(climcad.this.y1R + climcad.this.y2R / 2) - (r0 + r * r1)), (int)(2.0 * (r0 + r * r1)), (int)(2.0 * (r0 + r * r1)));
                        r += (double)cInt;
                    }
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    g.drawLine(climcad.this.x1R + climcad.this.x2R / 2, (int)((double)(climcad.this.y1R + climcad.this.y2R / 2) - r0), climcad.this.x1R + climcad.this.x2R / 2, (int)((double)(climcad.this.y1R + climcad.this.y2R / 2) - r0 - rMax * r1));
                    g.drawLine(climcad.this.x1R + climcad.this.x2R / 2, (int)((double)(climcad.this.y1R + climcad.this.y2R / 2) + r0), climcad.this.x1R + climcad.this.x2R / 2, (int)((double)(climcad.this.y1R + climcad.this.y2R / 2) + r0 + rMax * r1));
                    g.drawLine((int)((double)(climcad.this.x1R + climcad.this.x2R / 2) - r0), climcad.this.y1R + climcad.this.y2R / 2, (int)((double)(climcad.this.x1R + climcad.this.x2R / 2) - r0 - rMax * r1), climcad.this.y1R + climcad.this.y2R / 2);
                    g.drawLine((int)((double)(climcad.this.x1R + climcad.this.x2R / 2) + r0), climcad.this.y1R + climcad.this.y2R / 2, (int)((double)(climcad.this.x1R + climcad.this.x2R / 2) + r0 + rMax * r1), climcad.this.y1R + climcad.this.y2R / 2);
                    i = 0;
                    while (i < climcad.this.Wv.length) {
                        double[] date = climcad.this.HOYtoDate(i);
                        if (climcad.this.Wv[i] <= rMax && climcad.this.selectMonth[(int)date[0] - 1]) {
                            double xp = (double)(climcad.this.x1R + climcad.this.x2R / 2) + Math.sin(climcad.this.Wd[i] * Math.PI / 180.0) * (climcad.this.Wv[i] * r1 + r0);
                            double yp = (double)(climcad.this.y1R + climcad.this.y2R / 2) - Math.cos(climcad.this.Wd[i] * Math.PI / 180.0) * (climcad.this.Wv[i] * r1 + r0);
                            g.setColor(climcad.this.getColor(climcad.this.T[i]));
                            g.drawOval((int)xp - 1, (int)yp - 1, 3, 3);
                        }
                        ++i;
                    }
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(climcad.this.tableColor);
                    g.setFont(new Font("dialog", 1, 10));
                    g.drawString("N", climcad.this.x1R + climcad.this.x2R / 2 - 3, (int)((double)(climcad.this.y1R + climcad.this.y2R / 2) - r0 - rMax * r1) - 2);
                    g.drawString("S", climcad.this.x1R + climcad.this.x2R / 2 - 3, (int)((double)(climcad.this.y1R + climcad.this.y2R / 2) + r0 + rMax * r1) + 13);
                    g.drawString("E", (int)((double)(climcad.this.x1R + climcad.this.x2R / 2) + r0 + rMax * r1) + 3, climcad.this.y1R + climcad.this.y2R / 2 + 5);
                    g.drawString(climcad.this.english ? "W" : "O", (int)((double)(climcad.this.x1R + climcad.this.x2R / 2) - r0 - rMax * r1) - 13, climcad.this.y1R + climcad.this.y2R / 2 + 5);
                    g.setColor(climcad.this.tableColor);
                    g.setFont(new Font("dialog", 0, 8));
                    int r2 = 0;
                    while ((double)r2 < rMax + 1.0) {
                        g.drawString(String.format("%.1f m/s", r2), climcad.this.x1R + climcad.this.x2R / 2 + 3, (int)((double)(climcad.this.y1R + climcad.this.y2R / 2) + r0 + (double)r2 * r1) + 5);
                        r2 += cInt;
                    }
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            } else {
                climcad.this.jPa_0.setVisible(false);
                g.setColor(Color.white);
                g.fillRect(0, 0, centerX * 2 + 20, centerY * 2 + 30);
                if (climcad.this.displayMode == 20 || climcad.this.displayMode == 21) {
                    double hoy;
                    double stylet = 40.0;
                    double cercle = (double)centerY * 0.9;
                    int startD = 0;
                    int endD = 0;
                    int startM = 0;
                    int endM = 0;
                    if (Double.parseDouble(climcad.this.stationLat) >= 0.0) {
                        startD = 172;
                        endD = 355;
                        startM = 6;
                        endM = 12;
                    } else {
                        startD = 1;
                        endD = 172;
                        startM = 0;
                        endM = 6;
                    }
                    if (climcad.this.displayMode == 20) {
                        int y1;
                        int x1;
                        int y0;
                        int x0;
                        g.setColor(Color.lightGray);
                        double rr = cercle / 90.0;
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        int i = 0;
                        while (i <= 90) {
                            if (i == 0) {
                                g.setColor(Color.darkGray);
                            } else {
                                g.setColor(Color.lightGray);
                            }
                            g.drawOval((int)((double)centerX - (double)i * rr), (int)((double)centerY - (double)i * rr), (int)((double)(i * 2) * rr), (int)((double)(i * 2) * rr));
                            i += 10;
                        }
                        g.drawLine(centerX - (int)(rr * 90.0 + 5.0), centerY, centerX + (int)(rr * 90.0 + 5.0), centerY);
                        g.drawLine(centerX, centerY - (int)(rr * 90.0 + 5.0), centerX, centerY + (int)(rr * 90.0 + 5.0));
                        g.setColor(Color.lightGray);
                        int az = 0;
                        while (az < 360) {
                            rr = (int)(cercle - 0.0 * cercle / 90.0);
                            x0 = centerX + (int)(Math.sin(Math.toRadians(az)) * rr);
                            y0 = centerY - (int)(Math.cos(Math.toRadians(az)) * rr);
                            rr = (int)(cercle - 80.0 * cercle / 90.0);
                            x1 = centerX + (int)(Math.sin(Math.toRadians(az)) * rr);
                            y1 = centerY - (int)(Math.cos(Math.toRadians(az)) * rr);
                            g.drawLine(x0, y0, x1, y1);
                            az += 10;
                        }
                        az = 0;
                        while (az < 360) {
                            rr = (int)(cercle - 0.0 * cercle / 90.0);
                            x0 = centerX + (int)(Math.sin(Math.toRadians(az)) * rr);
                            y0 = centerY - (int)(Math.cos(Math.toRadians(az)) * rr);
                            rr = (int)(cercle + 2.0 * cercle / 90.0);
                            x1 = centerX + (int)(Math.sin(Math.toRadians(az)) * rr);
                            y1 = centerY - (int)(Math.cos(Math.toRadians(az)) * rr);
                            g.drawLine(x0, y0, x1, y1);
                            az += 2;
                        }
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    }
                    int xx = 0;
                    int yy = 0;
                    int d = startD;
                    while (d < endD) {
                        double h = 1.0;
                        while (h < 23.0) {
                            double k = 0.0;
                            while (k < 1.0) {
                                hoy = (double)(d * 24) + h;
                                double T0 = climcad.this.T[(int)hoy];
                                double T1 = climcad.this.T[(int)hoy + 1];
                                double TT = T0 + k * (T1 - T0);
                                double[] dat = climcad.this.transpos.getHCAZ(Math.toRadians(Double.parseDouble(climcad.this.stationLat)), hoy + k);
                                double hh = dat[0];
                                double az = dat[1];
                                if (hh > 0.0) {
                                    if (climcad.this.displayMode == 21) {
                                        xx = Math.min(32000, centerX - (int)(Math.sin(az) * stylet / Math.tan(hh)));
                                        yy = Math.min(32000, centerY + (int)(Math.cos(az) * stylet / Math.tan(hh)));
                                    } else {
                                        int rr = (int)(cercle - Math.toDegrees(hh) * cercle / 90.0);
                                        xx = Math.min(32000, centerX + (int)(Math.sin(az) * (double)rr));
                                        yy = Math.min(32000, centerY - (int)(Math.cos(az) * (double)rr));
                                    }
                                    Color col = climcad.this.getColor(TT);
                                    double[] date = climcad.this.HOYtoDate(hoy);
                                    if (climcad.this.selectMonth[(int)date[0] - 1]) {
                                        g.setColor(col);
                                    } else {
                                        int sx = (col.getRed() + col.getGreen() + col.getBlue()) / 3;
                                        g.setColor(new Color(sx, sx, sx));
                                    }
                                    g.fillRect(xx - 2, yy - 2, 5, 5);
                                }
                                k += 0.005;
                            }
                            h += 1.0;
                        }
                        ++d;
                    }
                    int[] xPoints = new int[28801];
                    int[] yPoints = new int[28801];
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int m = startM;
                    while (m <= endM) {
                        int i = 0;
                        double h = 0.2;
                        while (h < 24.0) {
                            double hoy2 = (double)(climcad.this.JM[m] * 24) + h;
                            double[] dat = climcad.this.transpos.getHCAZ(Math.toRadians(Double.parseDouble(climcad.this.stationLat)), hoy2);
                            double hh = dat[0];
                            double az = dat[1];
                            if (hh > 0.0) {
                                if (climcad.this.displayMode == 21) {
                                    xPoints[i] = Math.min(32000, (int)((double)centerX - Math.sin(az) * stylet / Math.tan(hh)));
                                    yPoints[i] = Math.min(32000, (int)((double)centerY + Math.cos(az) * stylet / Math.tan(hh)));
                                } else {
                                    int rr = (int)(cercle - Math.toDegrees(hh) * cercle / 90.0);
                                    xPoints[i] = Math.min(32000, (int)((double)centerX + Math.sin(az) * (double)rr));
                                    yPoints[i] = Math.min(32000, (int)((double)centerY - Math.cos(az) * (double)rr));
                                }
                                ++i;
                            }
                            h += 0.2;
                        }
                        g.setColor(Color.white);
                        g.drawPolyline(xPoints, yPoints, i);
                        ++m;
                    }
                    xPoints = new int[28801];
                    yPoints = new int[28801];
                    int i = 0;
                    double h = 0.0;
                    while (h < 24.0) {
                        double m2 = 1.0;
                        while (m2 < 13.0) {
                            double hoy3 = m2 * 30.0 * 24.0 + h;
                            double[] dat = climcad.this.transpos.getHCAZ(Math.toRadians(Double.parseDouble(climcad.this.stationLat)), hoy3);
                            double hh = dat[0];
                            double az = dat[1];
                            if (hh > 0.0) {
                                if (climcad.this.displayMode == 21) {
                                    xPoints[i] = Math.min(32000, (int)((double)centerX - Math.sin(az) * stylet / Math.tan(hh)));
                                    yPoints[i] = Math.min(32000, (int)((double)centerY + Math.cos(az) * stylet / Math.tan(hh)));
                                } else {
                                    int rr = (int)(cercle - Math.toDegrees(hh) * cercle / 90.0);
                                    xPoints[i] = Math.min(32000, (int)((double)centerX + Math.sin(az) * (double)rr));
                                    yPoints[i] = Math.min(32000, (int)((double)centerY - Math.cos(az) * (double)rr));
                                }
                                ++i;
                            }
                            m2 += 1.0;
                        }
                        g.setColor(Color.white);
                        g.drawPolyline(xPoints, yPoints, i);
                        i = 0;
                        h += 1.0;
                    }
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    h = 1.0;
                    while (h < 23.0) {
                        hoy = 4128.0 + h;
                        double[] dat = climcad.this.transpos.getHCAZ(Math.toRadians(Double.parseDouble(climcad.this.stationLat)), hoy);
                        double hh = dat[0];
                        double az = dat[1];
                        if (hh > 0.0) {
                            if (climcad.this.displayMode == 21) {
                                xx = Math.min(32000, centerX - (int)(Math.sin(az) * stylet / Math.tan(hh)));
                                yy = Math.min(32000, centerY + (int)(Math.cos(az) * stylet / Math.tan(hh)) + 20);
                            } else {
                                int rr = (int)(cercle - Math.toDegrees(hh) * cercle / 90.0);
                                xx = Math.min(32000, centerX + (int)(Math.sin(az) * (double)rr));
                                yy = Math.min(32000, centerY - (int)(Math.cos(az) * (double)rr) - 20);
                            }
                            g.setColor(Color.gray);
                            g.drawString(String.format("%.0f", h), xx - 5, yy);
                            if (h == 12.0) {
                                g.drawString("JUN", xx - 10, yy + 40);
                            }
                        }
                        hoy = 8520.0 + h;
                        dat = climcad.this.transpos.getHCAZ(Math.toRadians(Double.parseDouble(climcad.this.stationLat)), hoy);
                        hh = dat[0];
                        az = dat[1];
                        if (hh > 0.0) {
                            if (climcad.this.displayMode == 21) {
                                xx = Math.min(32000, centerX - (int)(Math.sin(az) * stylet / Math.tan(hh)));
                                yy = Math.min(32000, centerY + (int)(Math.cos(az) * stylet / Math.tan(hh)) - 10);
                            } else {
                                int rr = (int)(cercle - Math.toDegrees(hh) * cercle / 90.0);
                                xx = Math.min(32000, centerX + (int)(Math.sin(az) * (double)rr));
                                yy = Math.min(32000, centerY - (int)(Math.cos(az) * (double)rr) + 20);
                            }
                            g.setColor(Color.gray);
                            g.drawString(String.format("%.0f", h), xx - 5, yy);
                            if (h == 12.0) {
                                g.drawString("DEC", xx - 10, yy - 30);
                            }
                        }
                        h += 1.0;
                    }
                    g.setColor(Color.black);
                    g.drawString("N", centerX - 3, (int)((double)centerY - cercle - 10.0));
                    g.drawString("S", centerX - 3, (int)((double)centerY + cercle + 20.0));
                    if (climcad.this.displayMode == 21) {
                        g.drawString("DWC sundial", centerX - 40, (int)((double)centerY + cercle));
                        xx = centerX - 85;
                        yy = 40;
                        if (Double.parseDouble(climcad.this.stationLat) >= 0.0) {
                            yy = 2 * centerY - 120;
                        }
                    } else {
                        g.drawString("DWC stereograph", centerX * 2 - 90, 20);
                        g.drawString("E", (int)((double)centerX + cercle + 10.0), centerY + 5);
                        g.drawString("W", (int)((double)centerX - cercle - 20.0), centerY + 5);
                        xx = 10;
                        yy = 20;
                    }
                    g.drawString(String.valueOf(climcad.this.english ? "Station name : " : "Nom de la station : ") + climcad.this.stationName + " (" + climcad.this.stationCountry + ")", xx, yy);
                    g.drawString(String.valueOf(climcad.this.english ? "Latitude  : " : "Latitude  : ") + climcad.this.stationLat + "\u00ba", xx, yy + 10);
                    g.drawString(String.valueOf(climcad.this.english ? "Longitude : " : "Longitude : ") + climcad.this.stationLon + "\u00ba", xx, yy + 20);
                    g.drawString(String.valueOf(climcad.this.english ? "Altitude  : " : "Altitude  : ") + climcad.this.stationAlt + " m", xx, yy + 30);
                    g.drawString(String.valueOf(climcad.this.english ? "Temp correction : " : "Correction temp : ") + String.format("%1.1f", climcad.this.ICUtempOffset - (climcad.this.userAltVal - climcad.this.stationAltVal) / 100.0 * 0.65) + " K", xx, yy + 40);
                    if (climcad.this.displayMode == 21) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setColor(Color.black);
                        g.drawLine(centerX - 10, centerY, centerX + 10, centerY);
                        g.drawLine(centerX, centerY - 10, centerX, centerY + (int)stylet);
                        g.drawLine(centerX - 10, centerY, centerX, centerY + (int)stylet);
                        g.drawLine(centerX + 10, centerY, centerX, centerY + (int)stylet);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    }
                    i = 0;
                    while (i < climcad.this.x2) {
                        double tt = (double)i / (double)climcad.this.x2 * (climcad.this.ex1[climcad.this.zoomMode] - climcad.this.ex0[climcad.this.zoomMode]) + climcad.this.ex0[climcad.this.zoomMode];
                        g.setColor(climcad.this.getColorPal(tt, climcad.this.palette));
                        g.drawLine(i + climcad.this.x1, climcad.this.y1 + climcad.this.y2, i + climcad.this.x1, climcad.this.y1 + climcad.this.y2 + 3);
                        ++i;
                    }
                    double T = climcad.this.ex0[climcad.this.zoomMode];
                    while (T <= climcad.this.ex1[climcad.this.zoomMode]) {
                        g.setFont(new Font("dialog", 0, 10));
                        g.setColor(climcad.this.graphLegendColor);
                        xx = climcad.this.x1 + (int)((double)climcad.this.x2 / (climcad.this.ex1[climcad.this.zoomMode] - climcad.this.ex0[climcad.this.zoomMode]) * (T - climcad.this.ex0[climcad.this.zoomMode])) - 5;
                        g.drawString(String.valueOf(String.format("%.0f", T)) + "\u00baC", xx, climcad.this.y1 + climcad.this.y2 + 13);
                        T += climcad.this.exi[climcad.this.zoomMode];
                    }
                }
            }
            g.setColor(climcad.this.tableColor);
            g.setFont(climcad.this.tableFont);
            g.drawString(climcad.this.appName, climcad.this.x1 + climcad.this.x2 - 230, climcad.this.x1 + climcad.this.y2 - 5);
        }
    }

    class myMenu
    extends JMenuBar {
        String stringOpenEpw;
        String stringOpenDat;
        String stringSaveOut;
        String stringQuit;
        String stringDisplayHome;
        String stringDisplayAnalysis;
        String stringDisplayPercent;
        String stringDisplayHours;
        String stringDisplayTemp;
        String stringDisplayTwilight;
        String stringDisplaySun;
        String stringDisplayCover;
        String stringDisplayWindV;
        String stringDisplayWindD;
        String stringDisplayWindR;
        String stringDisplayStereo;
        String stringDisplaySundial;
        String stringZoomGlobal;
        String stringZoomHot;
        String stringZoomTemp;
        String stringZoomCold;
        String stringZoomArctic;
        String stringPalette0;
        String stringPalette1;
        String stringPalette2;
        String stringSelectMonth1;
        String stringSelectMonth2;
        String stringSelectMonth3;
        String stringSelectMonth4;
        String stringSelectMonth5;
        String stringSelectMonth6;
        String stringSelectMonth7;
        String stringSelectMonth8;
        String stringSelectMonth9;
        String stringSelectMonth10;
        String stringSelectMonth11;
        String stringSelectMonth12;
        String stringSelectMonthAll;
        String stringSelectMonthNone;
        String stringSimICU;
        String stringSimAlt;
        String stringSimGIECtoday;
        String stringSimGIEC2040;
        String stringSimGIEC2060;
        String stringSimGIEC2100;
        String stringSimGIECssp1;
        String stringSimGIECssp2;
        String stringSimGIECssp3;
        String stringManual;
        String stringIgloo;
        String stringEPWLBT;
        String stringLang;
        String stringAbout;

        public myMenu() {
            this.stringOpenEpw = climcad.this.english ? "Open (.epw) ..." : "Ouvrir (.epw) ...";
            this.stringOpenDat = climcad.this.english ? "Open (.dat) ..." : "Ouvrir (.dat) ...";
            this.stringSaveOut = climcad.this.english ? "Export strategies ..." : "Enregistrer l'analyse ...";
            this.stringQuit = climcad.this.english ? "Quit" : "Quitter";
            this.stringDisplayHome = climcad.this.english ? "Home" : "Home";
            this.stringDisplayAnalysis = climcad.this.english ? "Strategies" : "Analyse";
            this.stringDisplayPercent = climcad.this.english ? "Strategies %" : "Analyse %";
            this.stringDisplayHours = climcad.this.english ? "Strategies hours" : "Analyse heures";
            this.stringDisplayTemp = climcad.this.english ? "Temperature" : "Temp\u00e9rature";
            this.stringDisplayTwilight = climcad.this.english ? "Day - Night" : "Jour - nuit";
            this.stringDisplaySun = climcad.this.english ? "Solar radiation" : "Rayonnement solaire";
            this.stringDisplayCover = climcad.this.english ? "Opaque sky cover" : "Couverture nuageuse";
            this.stringDisplayWindV = climcad.this.english ? "Wind speed" : "Vent vitesse";
            this.stringDisplayWindD = climcad.this.english ? "Wind direction" : "Vent direction";
            this.stringDisplayWindR = climcad.this.english ? "Wind rose" : "Rose des vents";
            this.stringDisplayStereo = climcad.this.english ? "Stereograph" : "St\u00c3\u00a9r\u00c3\u00a9ographe";
            this.stringDisplaySundial = climcad.this.english ? "Sundial" : "Cadran solaire";
            this.stringZoomGlobal = climcad.this.english ? "Global view" : "Vue globale";
            this.stringZoomHot = climcad.this.english ? "Zoom hot climates" : "Zoom climats chauds";
            this.stringZoomTemp = climcad.this.english ? "Zoom temperate climates" : "Zoom climats temper\u00e9s";
            this.stringZoomCold = climcad.this.english ? "Zoom cold climates" : "Zoom climats froids";
            this.stringZoomArctic = climcad.this.english ? "Zoom arctic climates" : "Zoom climats arctiques";
            this.stringPalette0 = climcad.this.english ? "T Default palette" : "T Palette standard";
            this.stringPalette1 = climcad.this.english ? "T Firebird" : "T Phoebus";
            this.stringPalette2 = climcad.this.english ? "T Rainbow" : "T Arc en ciel";
            this.stringSelectMonth1 = climcad.this.english ? "January" : "Janvier";
            this.stringSelectMonth2 = climcad.this.english ? "February" : "F\u00e9vrier";
            this.stringSelectMonth3 = climcad.this.english ? "March" : "Mars";
            this.stringSelectMonth4 = climcad.this.english ? "April" : "Avril";
            this.stringSelectMonth5 = climcad.this.english ? "May" : "Mai";
            this.stringSelectMonth6 = climcad.this.english ? "June" : "Juin";
            this.stringSelectMonth7 = climcad.this.english ? "July" : "Juillet";
            this.stringSelectMonth8 = climcad.this.english ? "August" : "Ao\u00fbt";
            this.stringSelectMonth9 = climcad.this.english ? "September" : "Septembre";
            this.stringSelectMonth10 = climcad.this.english ? "October" : "Octobre";
            this.stringSelectMonth11 = climcad.this.english ? "November" : "Novembre";
            this.stringSelectMonth12 = climcad.this.english ? "December" : "D\u00e9cembre";
            this.stringSelectMonthAll = climcad.this.english ? "Select all" : "Tout s\u00e9lectionner";
            this.stringSelectMonthNone = climcad.this.english ? "Deselect all" : "Rien s\u00e9lectionner";
            this.stringSimICU = climcad.this.english ? "Temperature forcing..." : "Forcage temp\u00e9rature...";
            this.stringSimAlt = climcad.this.english ? "Other altitude..." : "Autre altitude...";
            this.stringSimGIECtoday = climcad.this.english ? "Present climate" : "Climat pr\u00e9sent";
            this.stringSimGIEC2040 = climcad.this.english ? "Climate warming 2040" : "Changement climatique 2040)";
            this.stringSimGIEC2060 = climcad.this.english ? "Climate warming 2060" : "Changement climatique 2060)";
            this.stringSimGIEC2100 = climcad.this.english ? "Climate warming 2100" : "Changement climatique 2100)";
            this.stringSimGIECssp1 = climcad.this.english ? "Scenario SSP1-2.6" : "Scenario SSP1-2.6)";
            this.stringSimGIECssp2 = climcad.this.english ? "Scenario SSP2-4.5" : "Scenario SSP2-4.5)";
            this.stringSimGIECssp3 = climcad.this.english ? "Scenario SSP3-7.0" : "Scenario SSP5-7.0)";
            this.stringManual = climcad.this.english ? "Manual" : "Manuel";
            this.stringIgloo = climcad.this.english ? "The passive igloo project" : "Le 'passive igloo project'";
            this.stringEPWLBT = climcad.this.english ? "EPW climate data" : "Fichiers climatiques EPW";
            this.stringLang = climcad.this.english ? "Version fran\u00e7aise" : "English version";
            this.stringAbout = climcad.this.english ? "About - terms of use" : "A propos - conditions d'utilisation";
            JMenu fileMenu = new JMenu(climcad.this.english ? "File" : "Fichier");
            JMenu optionsMenu = new JMenu(climcad.this.english ? "Display" : "Affichage");
            JMenu selectMenu = new JMenu(climcad.this.english ? "Select" : "S\u00e9lection");
            JMenu simMenu = new JMenu(climcad.this.english ? "Climate" : "Climat");
            JMenu helpMenu = new JMenu(climcad.this.english ? "Help" : "Aide");
            ActionListener menuListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String string = event.getActionCommand();
                    if (string.equals(myMenu.this.stringOpenDat)) {
                        climcad.this.openDlg(String.valueOf(((myMenu)myMenu.this).climcad.this.appName) + " : open ClimCAD data file", "dat");
                        climcad.this.readFile(((myMenu)myMenu.this).climcad.this.ClimateFn, "dat");
                        climcad.this.setTitle(String.valueOf(((myMenu)myMenu.this).climcad.this.appName) + " - " + ((myMenu)myMenu.this).climcad.this.ClimateFn + " (DAT)");
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringOpenEpw)) {
                        climcad.this.openDlg(String.valueOf(((myMenu)myMenu.this).climcad.this.appName) + " : open EPW climate file", "epw");
                        climcad.this.readFile(((myMenu)myMenu.this).climcad.this.ClimateFn, "epw");
                        climcad.this.setTitle(String.valueOf(((myMenu)myMenu.this).climcad.this.appName) + " - " + ((myMenu)myMenu.this).climcad.this.ClimateFn + " (EPW)");
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSaveOut)) {
                        String outFn = String.valueOf(climcad.this.saveDlg(String.valueOf(((myMenu)myMenu.this).climcad.this.appName) + " : save results file", "txt")) + ".txt";
                        climcad.this.writeFile(((myMenu)myMenu.this).climcad.this.outAnalysis, outFn);
                    } else if (string.equals(myMenu.this.stringQuit)) {
                        System.exit(0);
                    } else if (string.equals(myMenu.this.stringZoomGlobal)) {
                        ((myMenu)myMenu.this).climcad.this.zoomMode = 0;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringZoomHot)) {
                        ((myMenu)myMenu.this).climcad.this.zoomMode = 1;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringZoomTemp)) {
                        ((myMenu)myMenu.this).climcad.this.zoomMode = 2;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringZoomCold)) {
                        ((myMenu)myMenu.this).climcad.this.zoomMode = 3;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringZoomArctic)) {
                        ((myMenu)myMenu.this).climcad.this.zoomMode = 4;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayHome)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 0;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayAnalysis)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 1;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayPercent)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 2;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayHours)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 3;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayTemp)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 4;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayTwilight)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 5;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplaySun)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 6;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayWindV)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 7;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayWindD)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 8;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayWindR)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 9;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayCover)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 10;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplayStereo)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 20;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringDisplaySundial)) {
                        ((myMenu)myMenu.this).climcad.this.displayMode = 21;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringPalette0)) {
                        ((myMenu)myMenu.this).climcad.this.palette = 0;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringPalette1)) {
                        ((myMenu)myMenu.this).climcad.this.palette = 1;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringPalette2)) {
                        ((myMenu)myMenu.this).climcad.this.palette = 2;
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth1)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[0] = !((myMenu)myMenu.this).climcad.this.selectMonth[0];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth2)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[1] = !((myMenu)myMenu.this).climcad.this.selectMonth[1];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth3)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[2] = !((myMenu)myMenu.this).climcad.this.selectMonth[2];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth4)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[3] = !((myMenu)myMenu.this).climcad.this.selectMonth[3];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth5)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[4] = !((myMenu)myMenu.this).climcad.this.selectMonth[4];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth6)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[5] = !((myMenu)myMenu.this).climcad.this.selectMonth[5];
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth7)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[6] = !((myMenu)myMenu.this).climcad.this.selectMonth[6];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth8)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[7] = !((myMenu)myMenu.this).climcad.this.selectMonth[7];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth9)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[8] = !((myMenu)myMenu.this).climcad.this.selectMonth[8];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth10)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[9] = !((myMenu)myMenu.this).climcad.this.selectMonth[9];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth11)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[10] = !((myMenu)myMenu.this).climcad.this.selectMonth[10];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonth12)) {
                        ((myMenu)myMenu.this).climcad.this.selectMonth[11] = !((myMenu)myMenu.this).climcad.this.selectMonth[11];
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonthAll)) {
                        Arrays.fill(((myMenu)myMenu.this).climcad.this.selectMonth, true);
                        climcad.this.setJMenuBar(new myMenu());
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSelectMonthNone)) {
                        Arrays.fill(((myMenu)myMenu.this).climcad.this.selectMonth, false);
                        climcad.this.setJMenuBar(new myMenu());
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimICU)) {
                        climcad.this.icuDlg();
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimAlt)) {
                        climcad.this.altDlg();
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimGIECtoday)) {
                        ((myMenu)myMenu.this).climcad.this.GIECdate = 0;
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimGIEC2040)) {
                        ((myMenu)myMenu.this).climcad.this.GIECdate = 1;
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimGIEC2060)) {
                        ((myMenu)myMenu.this).climcad.this.GIECdate = 2;
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimGIEC2100)) {
                        ((myMenu)myMenu.this).climcad.this.GIECdate = 3;
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimGIECssp1)) {
                        ((myMenu)myMenu.this).climcad.this.GIECssp = 1;
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimGIECssp2)) {
                        ((myMenu)myMenu.this).climcad.this.GIECssp = 2;
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringSimGIECssp3)) {
                        ((myMenu)myMenu.this).climcad.this.GIECssp = 3;
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringManual)) {
                        try {
                            String url = ((myMenu)myMenu.this).climcad.this.english ? "help.htm" : "help.htm";
                            Desktop.getDesktop().browse(URI.create(url));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.err.println("Error: " + e.getMessage());
                        }
                    } else if (string.equals(myMenu.this.stringIgloo)) {
                        try {
                            String url = ((myMenu)myMenu.this).climcad.this.english ? "http://igloo.sailworks.net" : "http://igloo.sailworks.net";
                            Desktop.getDesktop().browse(URI.create(url));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.err.println("Error: " + e.getMessage());
                        }
                    } else if (string.equals(myMenu.this.stringEPWLBT)) {
                        try {
                            String url = ((myMenu)myMenu.this).climcad.this.english ? "https://www.ladybug.tools/epwmap/" : "https://www.ladybug.tools/epwmap/";
                            Desktop.getDesktop().browse(URI.create(url));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.err.println("Error: " + e.getMessage());
                        }
                    } else if (string.equals(myMenu.this.stringLang)) {
                        ((myMenu)myMenu.this).climcad.this.english = !((myMenu)myMenu.this).climcad.this.english;
                        climcad.this.langSet();
                        climcad.this.setJMenuBar(new myMenu());
                        climcad.this.analyseData();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(false);
                        ((myMenu)myMenu.this).climcad.this.gDisplay.repaint();
                        ((myMenu)myMenu.this).climcad.this.gDisplay.setVisible(true);
                    } else if (string.equals(myMenu.this.stringAbout)) {
                        String txt = String.valueOf(((myMenu)myMenu.this).climcad.this.appName) + " - version " + ((myMenu)myMenu.this).climcad.this.appVersion + "<br><br>" + "Brought to you by 'the passive igloo project'<br>" + "http://igloo.sailworks.net<br><br>" + "Based on theoretical work by B.Givoni and M.Milne, 1979<br>" + "Cold climates, adaptation and development by P.Gallinelli, 2016<br>" + "Climate change scenarios IPCC Sixth Assessment Report, 2022 (simplified)<br><br>" + "License and warranty:<br>" + ((myMenu)myMenu.this).climcad.this.appName + " is licenced free of charge. So you are free to use and share it with<br>" + "others provided that copies are not made or distributed for commercial advantage.<br><br>" + "Output from " + ((myMenu)myMenu.this).climcad.this.appName + " may be published provided that acknowledgement is<br>" + "made to " + ((myMenu)myMenu.this).climcad.this.appName + " and the copyright holder.<br><br>" + "The program is provided 'as is' and the author does not give warranty of any kind.<br>" + "The entire risk as to the quality, performance and suitability for a particular<br>" + "purpose of the program is with you. In no event, the author will be liable to you<br>" + "for damages or losses including any general, special, incidental or consequential<br>" + "damages raising out of the use or inability to use the program.<br><br>" + ((myMenu)myMenu.this).climcad.this.appName + " is Copyright (c) 2025, Peter Gallinelli";
                        JOptionPane.showMessageDialog(null, climcad.this.transformToHTML(txt));
                    }
                }
            };
            JMenuItem item = new JMenuItem(this.stringOpenEpw);
            KeyStroke key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(79), 128, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new JMenuItem(this.stringOpenDat);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(79), 64, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new JMenuItem(this.stringSaveOut);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(83), 128, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new JMenuItem(this.stringQuit);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(81), 128, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            ButtonGroup displayButtonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(this.stringDisplayHome);
            item.setSelected(climcad.this.displayMode == 0);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            optionsMenu.addSeparator();
            item = new JRadioButtonMenuItem(this.stringDisplayAnalysis);
            item.setSelected(climcad.this.displayMode == 1);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplayPercent);
            item.setSelected(climcad.this.displayMode == 2);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplayHours);
            item.setSelected(climcad.this.displayMode == 3);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            optionsMenu.addSeparator();
            item = new JRadioButtonMenuItem(this.stringDisplayTemp);
            item.setSelected(climcad.this.displayMode == 4);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplayTwilight);
            item.setSelected(climcad.this.displayMode == 5);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplaySun);
            item.setSelected(climcad.this.displayMode == 6);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplayCover);
            item.setSelected(climcad.this.displayMode == 10);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplayWindV);
            item.setSelected(climcad.this.displayMode == 7);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplayWindD);
            item.setSelected(climcad.this.displayMode == 8);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplayWindR);
            item.setSelected(climcad.this.displayMode == 9);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            optionsMenu.addSeparator();
            item = new JRadioButtonMenuItem(this.stringDisplayStereo);
            item.setSelected(climcad.this.displayMode == 20);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringDisplaySundial);
            item.setSelected(climcad.this.displayMode == 21);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            displayButtonGroup.add(item);
            optionsMenu.addSeparator();
            ButtonGroup zoomButtonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(this.stringZoomGlobal);
            item.setSelected(climcad.this.zoomMode == 0);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            zoomButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringZoomHot);
            item.setSelected(climcad.this.zoomMode == 1);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            zoomButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringZoomTemp);
            item.setSelected(climcad.this.zoomMode == 2);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            zoomButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringZoomCold);
            item.setSelected(climcad.this.zoomMode == 3);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            zoomButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringZoomArctic);
            item.setSelected(climcad.this.zoomMode == 4);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            zoomButtonGroup.add(item);
            optionsMenu.addSeparator();
            ButtonGroup paletteButtonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(this.stringPalette0);
            item.setSelected(climcad.this.palette == 0);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            paletteButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringPalette1);
            item.setSelected(climcad.this.palette == 1);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            paletteButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringPalette2);
            item.setSelected(climcad.this.palette == 2);
            item.addActionListener(menuListener);
            optionsMenu.add(item);
            paletteButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth1);
            item.setSelected(climcad.this.selectMonth[0]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth2);
            item.setSelected(climcad.this.selectMonth[1]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth3);
            item.setSelected(climcad.this.selectMonth[2]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth4);
            item.setSelected(climcad.this.selectMonth[3]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth5);
            item.setSelected(climcad.this.selectMonth[4]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth6);
            item.setSelected(climcad.this.selectMonth[5]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth7);
            item.setSelected(climcad.this.selectMonth[6]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth8);
            item.setSelected(climcad.this.selectMonth[7]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth9);
            item.setSelected(climcad.this.selectMonth[8]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth10);
            item.setSelected(climcad.this.selectMonth[9]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth11);
            item.setSelected(climcad.this.selectMonth[10]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JRadioButtonMenuItem(this.stringSelectMonth12);
            item.setSelected(climcad.this.selectMonth[11]);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            selectMenu.addSeparator();
            item = new JMenuItem(this.stringSelectMonthAll);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JMenuItem(this.stringSelectMonthNone);
            item.addActionListener(menuListener);
            selectMenu.add(item);
            item = new JMenuItem(this.stringSimICU);
            item.addActionListener(menuListener);
            simMenu.add(item);
            item = new JMenuItem(this.stringSimAlt);
            item.addActionListener(menuListener);
            simMenu.add(item);
            simMenu.addSeparator();
            ButtonGroup GIECdateButtonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(this.stringSimGIECtoday);
            item.setSelected(climcad.this.GIECdate == 0);
            item.addActionListener(menuListener);
            simMenu.add(item);
            GIECdateButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringSimGIEC2040);
            item.setSelected(climcad.this.GIECdate == 1);
            item.addActionListener(menuListener);
            simMenu.add(item);
            GIECdateButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringSimGIEC2060);
            item.setSelected(climcad.this.GIECdate == 2);
            item.addActionListener(menuListener);
            simMenu.add(item);
            GIECdateButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringSimGIEC2100);
            item.setSelected(climcad.this.GIECdate == 3);
            item.addActionListener(menuListener);
            simMenu.add(item);
            GIECdateButtonGroup.add(item);
            simMenu.addSeparator();
            ButtonGroup GIECsspButtonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(this.stringSimGIECssp1);
            item.setSelected(climcad.this.GIECssp == 1);
            item.addActionListener(menuListener);
            simMenu.add(item);
            GIECsspButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringSimGIECssp2);
            item.setSelected(climcad.this.GIECssp == 2);
            item.addActionListener(menuListener);
            simMenu.add(item);
            GIECsspButtonGroup.add(item);
            item = new JRadioButtonMenuItem(this.stringSimGIECssp3);
            item.setSelected(climcad.this.GIECssp == 3);
            item.addActionListener(menuListener);
            simMenu.add(item);
            GIECsspButtonGroup.add(item);
            item = new JMenuItem(this.stringManual);
            key = KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(72), 128, false);
            item.setAccelerator(key);
            item.addActionListener(menuListener);
            helpMenu.add(item);
            item = new JMenuItem(this.stringLang);
            item.addActionListener(menuListener);
            helpMenu.add(item);
            helpMenu.addSeparator();
            item = new JMenuItem(this.stringEPWLBT);
            item.addActionListener(menuListener);
            helpMenu.add(item);
            helpMenu.addSeparator();
            item = new JMenuItem(this.stringIgloo);
            item.addActionListener(menuListener);
            helpMenu.add(item);
            item = new JMenuItem(this.stringAbout);
            item.addActionListener(menuListener);
            helpMenu.add(item);
            this.add(fileMenu);
            this.add(optionsMenu);
            this.add(selectMenu);
            this.add(simMenu);
            this.add(helpMenu);
        }
    }
}

